/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.accountkit.internal.SerializableHttpCookie;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class AccountKitCookieStore
implements CookieStore {
    private static final String SP_COOKIE_STORE = "cookieStore";
    private static final String SP_KEY_DELIMITER = "|";
    private static final String SP_KEY_DELIMITER_REGEX = "\\|";
    private static final List<String> ALLOW_PERSIST_DOMAINS = new ArrayList<String>();
    private static final List<String> ALLOW_PERSIST_COOKIE_NAMES = new ArrayList<String>();
    private final Map<URI, List<HttpCookie>> map = new HashMap<URI, List<HttpCookie>>();
    private final SharedPreferences sharedPreferences;

    public AccountKitCookieStore(Context context) {
        this.sharedPreferences = context.getSharedPreferences(SP_COOKIE_STORE, 0);
        this.loadFromSharedPreferences();
    }

    private void loadFromSharedPreferences() {
        Map allPairs = this.sharedPreferences.getAll();
        for (Map.Entry entry : allPairs.entrySet()) {
            String[] uriAndName = ((String)entry.getKey()).split(SP_KEY_DELIMITER_REGEX, 2);
            try {
                URI uri = new URI(uriAndName[0]);
                String encodedCookie = (String)entry.getValue();
                HttpCookie cookie = new SerializableHttpCookie().decode(encodedCookie);
                if (cookie == null) continue;
                List<HttpCookie> targetCookies = this.map.get(uri);
                if (targetCookies == null) {
                    targetCookies = new ArrayList<HttpCookie>();
                    this.map.put(uri, targetCookies);
                }
                targetCookies.add(cookie);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void saveToSharedPreferences(URI uri, HttpCookie cookie) {
        if (ALLOW_PERSIST_DOMAINS.contains(cookie.getDomain()) && ALLOW_PERSIST_COOKIE_NAMES.contains(cookie.getName())) {
            SharedPreferences.Editor editor = this.sharedPreferences.edit();
            editor.putString(uri.toString() + SP_KEY_DELIMITER + cookie.getName(), new SerializableHttpCookie().encode(cookie));
            editor.apply();
        }
    }

    @Override
    public synchronized void add(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie == null");
        }
        List<HttpCookie> cookies = this.map.get(uri = this.cookiesUri(uri));
        if (cookies == null) {
            cookies = new ArrayList<HttpCookie>();
            this.map.put(uri, cookies);
        } else {
            cookies.remove(cookie);
        }
        cookies.add(cookie);
        this.saveToSharedPreferences(uri, cookie);
    }

    private URI cookiesUri(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI("http", uri.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    @Override
    public synchronized List<HttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        List<HttpCookie> cookiesForUri = this.map.get(uri);
        if (cookiesForUri != null) {
            Iterator<HttpCookie> i = cookiesForUri.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                result.add(cookie);
            }
        }
        for (Map.Entry<URI, List<HttpCookie>> entry : this.map.entrySet()) {
            if (uri.equals(entry.getKey())) continue;
            List<HttpCookie> entryCookies = entry.getValue();
            Iterator<HttpCookie> i = entryCookies.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (!HttpCookie.domainMatches(cookie.getDomain(), uri.getHost())) continue;
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                if (result.contains(cookie)) continue;
                result.add(cookie);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        for (List<HttpCookie> list : this.map.values()) {
            Iterator<HttpCookie> i = list.iterator();
            while (i.hasNext()) {
                HttpCookie cookie = i.next();
                if (cookie.hasExpired()) {
                    i.remove();
                    continue;
                }
                if (result.contains(cookie)) continue;
                result.add(cookie);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized List<URI> getURIs() {
        ArrayList<URI> result = new ArrayList<URI>(this.map.keySet());
        result.remove(null);
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized boolean remove(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie == null");
        }
        List<HttpCookie> cookies = this.map.get(this.cookiesUri(uri));
        if (cookies != null) {
            return cookies.remove(cookie);
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll() {
        boolean result = !this.map.isEmpty();
        this.map.clear();
        return result;
    }

    static {
        ALLOW_PERSIST_DOMAINS.add(".accountkit.com");
        ALLOW_PERSIST_COOKIE_NAMES.add("aksb");
    }
}

