/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.internal.AccountKitController;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class Tracker {
    public static final String EXTRA_LOGIN_ERROR = "com.facebook.accountkit.sdk.EXTRA_LOGIN_ERROR";
    public static final String EXTRA_LOGIN_MODEL = "com.facebook.accountkit.sdk.EXTRA_LOGIN_MODEL";
    public static final String EXTRA_LOGIN_STATUS = "com.facebook.accountkit.sdk.EXTRA_LOGIN_STATUS";
    private boolean isPaused = false;
    private boolean isTracking = false;
    private final List<Intent> pendingBroadcasts = new ArrayList<Intent>();
    private final BroadcastReceiver receiver = new TrackerBroadcastReceiver(this);

    public void startTracking() {
        if (!this.isTracking) {
            this.isTracking = true;
            this.addBroadcastReceiver();
        }
        if (this.isPaused) {
            this.isPaused = false;
            ArrayList<Intent> intents = new ArrayList<Intent>(this.pendingBroadcasts);
            this.pendingBroadcasts.clear();
            for (Intent intent : intents) {
                if (!this.isTracking()) continue;
                this.onReceive(intent);
            }
        }
    }

    public void stopTracking() {
        if (!this.isTracking) {
            return;
        }
        this.isTracking = false;
        this.unregisterReceiver(this.receiver);
        this.pendingBroadcasts.clear();
    }

    public void pauseTracking() {
        this.isPaused = true;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    protected abstract List<String> getActionsStateChanged();

    protected boolean isLocal() {
        return true;
    }

    protected abstract void onReceive(Intent var1);

    private void addBroadcastReceiver() {
        IntentFilter filter = new IntentFilter();
        List<String> actionsStateChanged = this.getActionsStateChanged();
        for (String action : actionsStateChanged) {
            filter.addAction(action);
        }
        this.registerReceiver(this.receiver, filter);
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        Context context = AccountKitController.getApplicationContext();
        if (this.isLocal()) {
            LocalBroadcastManager.getInstance((Context)context).registerReceiver(receiver, filter);
        } else {
            context.registerReceiver(receiver, filter);
        }
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        Context context = AccountKitController.getApplicationContext();
        if (this.isLocal()) {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver(receiver);
        } else {
            context.unregisterReceiver(receiver);
        }
    }

    private static class TrackerBroadcastReceiver
    extends BroadcastReceiver {
        final WeakReference<Tracker> trackerRef;

        TrackerBroadcastReceiver(Tracker tracker) {
            this.trackerRef = new WeakReference<Tracker>(tracker);
        }

        public void onReceive(Context context, Intent intent) {
            String intentAction;
            Tracker tracker = (Tracker)this.trackerRef.get();
            if (tracker == null) {
                return;
            }
            List<String> actionsStateChanged = tracker.getActionsStateChanged();
            if (!actionsStateChanged.contains(intentAction = intent.getAction())) {
                return;
            }
            if (tracker.isPaused()) {
                tracker.pendingBroadcasts.add(intent);
            } else if (tracker.isTracking()) {
                tracker.onReceive(intent);
            }
        }
    }
}

