/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.Account;
import com.facebook.accountkit.AccountKitCallback;
import com.facebook.accountkit.AccountKitLoginResult;
import com.facebook.accountkit.EmailLoginModel;
import com.facebook.accountkit.LoggingBehaviorCollection;
import com.facebook.accountkit.LoginModel;
import com.facebook.accountkit.PhoneLoginModel;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.NotificationChannel;
import java.util.concurrent.Executor;

public final class AccountKit {
    private static volatile Executor executor;
    private static final Object LOCK;
    private static final LoggingBehaviorCollection loggingBehaviors;
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    public static final String APPLICATION_NAME_PROPERTY = "com.facebook.accountkit.ApplicationName";
    public static final String APPLICATION_DEFAULT_LANGUAGE = "com.facebook.accountkit.DefaultLanguage";
    public static final String CLIENT_TOKEN_PROPERTY = "com.facebook.accountkit.ClientToken";
    public static final String FACEBOOK_APP_EVENTS_ENABLED_PROPERTY = "com.facebook.accountkit.AccountKitFacebookAppEventsEnabled";

    public static LoggingBehaviorCollection getLoggingBehaviors() {
        return loggingBehaviors;
    }

    public static boolean isInitialized() {
        return AccountKitController.isInitialized();
    }

    @Deprecated
    public static synchronized void initialize(Context applicationContext) {
        AccountKit.initialize(applicationContext, null);
    }

    public static void initialize(Context applicationContext, InitializeCallback callback) {
        AccountKitController.initialize(applicationContext, callback);
    }

    @Deprecated
    public static EmailLoginModel logInWithEmail(String email, String responseType, @Nullable String initialAuthState) {
        return AccountKitController.logInWithEmail(email, responseType, initialAuthState);
    }

    @Deprecated
    public static PhoneLoginModel logInWithPhoneNumber(PhoneNumber phoneNumber, NotificationChannel sendWithFacebookNotification, String responseType, @Nullable String initialAuthState) {
        if (AccountKit.getCurrentAccessToken() != null) {
            AccountKit.logOut();
        }
        return AccountKitController.logInWithPhoneNumber(phoneNumber, sendWithFacebookNotification, responseType, initialAuthState, false);
    }

    public static void logOut() {
        AccountKitController.logOut();
    }

    private static void logOut(AccountKitCallback<Void> callback) {
        AccountKitController.logOut(callback);
    }

    public static void cancelLogin() {
        AccountKitController.cancelLogin();
    }

    @Nullable
    public static AccessToken getCurrentAccessToken() {
        return AccountKitController.getCurrentAccessToken();
    }

    public static void getCurrentAccount(AccountKitCallback<Account> callback) {
        AccountKitController.getCurrentAccount(callback);
    }

    public static EmailLoginModel getCurrentEmailLogInModel() {
        return AccountKitController.getCurrentEmailLogInModel();
    }

    public static PhoneLoginModel getCurrentPhoneNumberLogInModel() {
        return AccountKitController.getCurrentPhoneNumberLogInModel();
    }

    public static LoginModel getCurrentLogInModel() {
        LoginModel loginModel = AccountKitController.getCurrentPhoneNumberLogInModel();
        if (loginModel == null) {
            loginModel = AccountKitController.getCurrentEmailLogInModel();
        }
        return loginModel;
    }

    public static void onActivityCreate(Activity activity, Bundle savedInstanceState) {
        AccountKitController.onActivityCreate(activity, savedInstanceState);
    }

    public static void onActivityDestroy(Activity activity) {
        AccountKitController.onActivityDestroy(activity);
    }

    public static void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        AccountKitController.onActivitySaveInstanceState(activity, outState);
    }

    public static String getApplicationId() {
        return AccountKitController.getApplicationId();
    }

    public static String getApplicationName() {
        return AccountKitController.getApplicationName();
    }

    public static String getClientToken() {
        return AccountKitController.getClientToken();
    }

    public static boolean getAccountKitFacebookAppEventsEnabled() {
        return AccountKitController.getAccountKitFacebookAppEventsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                executor = AsyncTask.THREAD_POOL_EXECUTOR;
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutor(@NonNull Executor executor) {
        Object object = LOCK;
        synchronized (object) {
            AccountKit.executor = executor;
        }
    }

    @Nullable
    public static AccountKitLoginResult loginResultWithIntent(Intent data) {
        if (data == null) {
            return null;
        }
        Parcelable loginResult = data.getParcelableExtra("account_kit_log_in_result");
        if (!(loginResult instanceof AccountKitLoginResult)) {
            return null;
        }
        return (AccountKitLoginResult)loginResult;
    }

    static {
        LOCK = new Object();
        loggingBehaviors = new LoggingBehaviorCollection();
    }

    public static interface InitializeCallback {
        public void onInitialized();
    }
}

