/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.LoggingBehavior;
import com.facebook.accountkit.internal.Utility;
import java.util.Date;

public final class AccessToken
implements Parcelable {
    private static final long DEFAULT_TOKEN_REFRESH_INTERVAL = 604800L;
    private static final int PARCEL_VERSION = 2;
    private final String accountId;
    private final String applicationId;
    private final Date lastRefresh;
    private final String token;
    private final long tokenRefreshIntervalInSeconds;
    public static final Parcelable.Creator<AccessToken> CREATOR = new Parcelable.Creator<AccessToken>(){

        public AccessToken createFromParcel(Parcel source) {
            return new AccessToken(source);
        }

        public AccessToken[] newArray(int size) {
            return new AccessToken[size];
        }
    };

    public AccessToken(@NonNull String token, @NonNull String accountId, @NonNull String applicationId, long tokenRefreshIntervalInSeconds, @Nullable Date lastRefreshTime) {
        this.token = token;
        this.accountId = accountId;
        this.applicationId = applicationId;
        this.tokenRefreshIntervalInSeconds = tokenRefreshIntervalInSeconds;
        this.lastRefresh = lastRefreshTime != null ? lastRefreshTime : new Date();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Date getLastRefresh() {
        return this.lastRefresh;
    }

    public String getToken() {
        return this.token;
    }

    public long getTokenRefreshIntervalSeconds() {
        return this.tokenRefreshIntervalInSeconds;
    }

    public String toString() {
        return "{AccessToken token:" + this.tokenToString() + " accountId:" + this.accountId + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessToken)) {
            return false;
        }
        AccessToken o = (AccessToken)other;
        return this.tokenRefreshIntervalInSeconds == o.tokenRefreshIntervalInSeconds && Utility.areObjectsEqual(this.accountId, o.accountId) && Utility.areObjectsEqual(this.applicationId, o.applicationId) && Utility.areObjectsEqual(this.lastRefresh, o.lastRefresh) && Utility.areObjectsEqual(this.token, o.token);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + Utility.getHashCode(this.accountId);
        result = result * 31 + Utility.getHashCode(this.applicationId);
        result = result * 31 + Utility.getHashCode(this.lastRefresh);
        result = result * 31 + Utility.getHashCode(this.token);
        result = result * 31 + Utility.getHashCode(this.tokenRefreshIntervalInSeconds);
        return result;
    }

    private String tokenToString() {
        if (this.token == null) {
            return "null";
        }
        if (AccountKit.getLoggingBehaviors().isEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
            return this.token;
        }
        return "ACCESS_TOKEN_REMOVED";
    }

    private AccessToken(Parcel parcel) {
        String toSetToken;
        int version = 1;
        try {
            version = parcel.readInt();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            toSetToken = parcel.readString();
        }
        catch (ClassCastException e) {
            parcel.readLong();
            toSetToken = parcel.readString();
        }
        this.token = toSetToken;
        this.accountId = parcel.readString();
        this.lastRefresh = new Date(parcel.readLong());
        this.applicationId = parcel.readString();
        this.tokenRefreshIntervalInSeconds = version == 2 ? parcel.readLong() : 604800L;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(2);
        dest.writeString(this.token);
        dest.writeString(this.accountId);
        dest.writeLong(this.lastRefresh.getTime());
        dest.writeString(this.applicationId);
        dest.writeLong(this.tokenRefreshIntervalInSeconds);
    }
}

