/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json;

import com.facebook.airlift.json.JsonKeySerde;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Provider;

public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final JsonFactory jsonFactory;
    private Map<Class<?>, JsonSerializer<?>> keySerializers;
    private Map<Class<?>, KeyDeserializer> keyDeserializers;
    private Map<Class<?>, JsonSerializer<?>> jsonSerializers;
    private Map<Class<?>, JsonDeserializer<?>> jsonDeserializers;
    private final Set<Module> modules = new HashSet<Module>();

    @Inject
    public ObjectMapperProvider() {
        this(new JsonFactory());
    }

    public ObjectMapperProvider(JsonFactory jsonFactory) {
        this.jsonFactory = Objects.requireNonNull(jsonFactory, "jsonFactory is null");
        this.modules.add((Module)new Jdk8Module());
        this.modules.add((Module)new JavaTimeModule());
        this.modules.add((Module)new GuavaModule());
        this.modules.add((Module)new ParameterNamesModule());
        try {
            this.getClass().getClassLoader().loadClass("org.joda.time.DateTime");
            this.modules.add((Module)new JodaModule());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Inject(optional=true)
    public void setJsonSerializers(Map<Class<?>, JsonSerializer<?>> jsonSerializers) {
        this.jsonSerializers = ImmutableMap.copyOf(jsonSerializers);
    }

    @Inject(optional=true)
    public void setJsonDeserializers(Map<Class<?>, JsonDeserializer<?>> jsonDeserializers) {
        this.jsonDeserializers = ImmutableMap.copyOf(jsonDeserializers);
    }

    @Inject(optional=true)
    public void setKeySerializers(@JsonKeySerde Map<Class<?>, JsonSerializer<?>> keySerializers) {
        this.keySerializers = keySerializers;
    }

    @Inject(optional=true)
    public void setKeyDeserializers(@JsonKeySerde Map<Class<?>, KeyDeserializer> keyDeserializers) {
        this.keyDeserializers = keyDeserializers;
    }

    @Inject(optional=true)
    public void setModules(Set<Module> modules) {
        this.modules.addAll(modules);
    }

    public ObjectMapper get() {
        ObjectMapper objectMapper = new ObjectMapper(this.jsonFactory);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_ABSENT, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.INFER_PROPERTY_MUTATORS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS});
        if (this.jsonSerializers != null || this.jsonDeserializers != null || this.keySerializers != null || this.keyDeserializers != null) {
            SimpleModule module = new SimpleModule(this.getClass().getName(), new Version(1, 0, 0, null, null, null));
            if (this.jsonSerializers != null) {
                for (Map.Entry<Class<?>, JsonSerializer<?>> entry : this.jsonSerializers.entrySet()) {
                    this.addSerializer(module, entry.getKey(), entry.getValue());
                }
            }
            if (this.jsonDeserializers != null) {
                for (Map.Entry<Class<?>, JsonSerializer<?>> entry : this.jsonDeserializers.entrySet()) {
                    this.addDeserializer(module, entry.getKey(), (JsonDeserializer)entry.getValue());
                }
            }
            if (this.keySerializers != null) {
                for (Map.Entry<Class<?>, JsonSerializer<?>> entry : this.keySerializers.entrySet()) {
                    this.addKeySerializer(module, entry.getKey(), entry.getValue());
                }
            }
            if (this.keyDeserializers != null) {
                for (Map.Entry<Class<?>, JsonSerializer<?>> entry : this.keyDeserializers.entrySet()) {
                    module.addKeyDeserializer(entry.getKey(), (KeyDeserializer)entry.getValue());
                }
            }
            this.modules.add((Module)module);
        }
        for (Module module : this.modules) {
            objectMapper.registerModule(module);
        }
        return objectMapper;
    }

    private <T> void addSerializer(SimpleModule module, Class<?> type, JsonSerializer<?> jsonSerializer) {
        module.addSerializer(type, jsonSerializer);
    }

    public <T> void addDeserializer(SimpleModule module, Class<?> type, JsonDeserializer<?> jsonDeserializer) {
        module.addDeserializer(type, jsonDeserializer);
    }

    private <T> void addKeySerializer(SimpleModule module, Class<?> type, JsonSerializer<?> keySerializer) {
        module.addKeySerializer(type, keySerializer);
    }
}

