/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TransactionCurrencyAmount;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="app_amount")
    private TransactionCurrencyAmount mAppAmount = null;
    @SerializedName(value="billing_end_time")
    private Long mBillingEndTime = null;
    @SerializedName(value="billing_reason")
    private String mBillingReason = null;
    @SerializedName(value="billing_start_time")
    private Long mBillingStartTime = null;
    @SerializedName(value="charge_type")
    private String mChargeType = null;
    @SerializedName(value="checkout_campaign_group_id")
    private String mCheckoutCampaignGroupId = null;
    @SerializedName(value="credential_id")
    private String mCredentialId = null;
    @SerializedName(value="fatura_id")
    private Long mFaturaId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="payment_option")
    private String mPaymentOption = null;
    @SerializedName(value="product_type")
    private EnumProductType mProductType = null;
    @SerializedName(value="provider_amount")
    private TransactionCurrencyAmount mProviderAmount = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="time")
    private Long mTime = null;
    @SerializedName(value="tracking_id")
    private String mTrackingId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Transaction loadJSON(String json, APIContext context) {
        Transaction transaction = (Transaction)Transaction.getGson().fromJson(json, Transaction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(transaction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        transaction.context = context;
        transaction.rawValue = json;
        return transaction;
    }

    public static APINodeList<Transaction> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<Transaction> transactions = new APINodeList<Transaction>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        transactions.add(Transaction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return transactions;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        transactions.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            transactions.add(Transaction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                transactions.add(Transaction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            transactions.add(Transaction.loadJSON(obj.toString(), context));
                        }
                    }
                    return transactions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        transactions.add(Transaction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return transactions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        transactions.add(Transaction.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return transactions;
                }
                transactions.clear();
                transactions.add(Transaction.loadJSON(json, context));
                return transactions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Transaction.getGson().toJson((Object)this);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public Transaction setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public TransactionCurrencyAmount getFieldAppAmount() {
        return this.mAppAmount;
    }

    public Transaction setFieldAppAmount(TransactionCurrencyAmount value) {
        this.mAppAmount = value;
        return this;
    }

    public Transaction setFieldAppAmount(String value) {
        Type type = new TypeToken<TransactionCurrencyAmount>(){}.getType();
        this.mAppAmount = (TransactionCurrencyAmount)TransactionCurrencyAmount.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldBillingEndTime() {
        return this.mBillingEndTime;
    }

    public Transaction setFieldBillingEndTime(Long value) {
        this.mBillingEndTime = value;
        return this;
    }

    public String getFieldBillingReason() {
        return this.mBillingReason;
    }

    public Transaction setFieldBillingReason(String value) {
        this.mBillingReason = value;
        return this;
    }

    public Long getFieldBillingStartTime() {
        return this.mBillingStartTime;
    }

    public Transaction setFieldBillingStartTime(Long value) {
        this.mBillingStartTime = value;
        return this;
    }

    public String getFieldChargeType() {
        return this.mChargeType;
    }

    public Transaction setFieldChargeType(String value) {
        this.mChargeType = value;
        return this;
    }

    public String getFieldCheckoutCampaignGroupId() {
        return this.mCheckoutCampaignGroupId;
    }

    public Transaction setFieldCheckoutCampaignGroupId(String value) {
        this.mCheckoutCampaignGroupId = value;
        return this;
    }

    public String getFieldCredentialId() {
        return this.mCredentialId;
    }

    public Transaction setFieldCredentialId(String value) {
        this.mCredentialId = value;
        return this;
    }

    public Long getFieldFaturaId() {
        return this.mFaturaId;
    }

    public Transaction setFieldFaturaId(Long value) {
        this.mFaturaId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Transaction setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldPaymentOption() {
        return this.mPaymentOption;
    }

    public Transaction setFieldPaymentOption(String value) {
        this.mPaymentOption = value;
        return this;
    }

    public EnumProductType getFieldProductType() {
        return this.mProductType;
    }

    public Transaction setFieldProductType(EnumProductType value) {
        this.mProductType = value;
        return this;
    }

    public TransactionCurrencyAmount getFieldProviderAmount() {
        return this.mProviderAmount;
    }

    public Transaction setFieldProviderAmount(TransactionCurrencyAmount value) {
        this.mProviderAmount = value;
        return this;
    }

    public Transaction setFieldProviderAmount(String value) {
        Type type = new TypeToken<TransactionCurrencyAmount>(){}.getType();
        this.mProviderAmount = (TransactionCurrencyAmount)TransactionCurrencyAmount.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Transaction setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public Long getFieldTime() {
        return this.mTime;
    }

    public Transaction setFieldTime(Long value) {
        this.mTime = value;
        return this;
    }

    public String getFieldTrackingId() {
        return this.mTrackingId;
    }

    public Transaction setFieldTrackingId(String value) {
        this.mTrackingId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Transaction copyFrom(Transaction instance) {
        this.mAccountId = instance.mAccountId;
        this.mAppAmount = instance.mAppAmount;
        this.mBillingEndTime = instance.mBillingEndTime;
        this.mBillingReason = instance.mBillingReason;
        this.mBillingStartTime = instance.mBillingStartTime;
        this.mChargeType = instance.mChargeType;
        this.mCheckoutCampaignGroupId = instance.mCheckoutCampaignGroupId;
        this.mCredentialId = instance.mCredentialId;
        this.mFaturaId = instance.mFaturaId;
        this.mId = instance.mId;
        this.mPaymentOption = instance.mPaymentOption;
        this.mProductType = instance.mProductType;
        this.mProviderAmount = instance.mProviderAmount;
        this.mStatus = instance.mStatus;
        this.mTime = instance.mTime;
        this.mTrackingId = instance.mTrackingId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Transaction> getParser() {
        return new APIRequest.ResponseParser<Transaction>(){

            @Override
            public APINodeList<Transaction> parseResponse(String response, APIContext context, APIRequest<Transaction> request) throws APIException.MalformedResponseException {
                return Transaction.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumProductType {
        VALUE_FACEBOOK_AD("facebook_ad"),
        VALUE_IG_AD("ig_ad"),
        NULL(null);

        private String value;

        private EnumProductType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

