/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TargetingProductAudienceSubSpec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingProductAudienceSpec
extends APINode {
    @SerializedName(value="exclusions")
    private List<TargetingProductAudienceSubSpec> mExclusions = null;
    @SerializedName(value="inclusions")
    private List<TargetingProductAudienceSubSpec> mInclusions = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingProductAudienceSpec loadJSON(String json, APIContext context) {
        TargetingProductAudienceSpec targetingProductAudienceSpec = (TargetingProductAudienceSpec)TargetingProductAudienceSpec.getGson().fromJson(json, TargetingProductAudienceSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingProductAudienceSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingProductAudienceSpec.context = context;
        targetingProductAudienceSpec.rawValue = json;
        return targetingProductAudienceSpec;
    }

    public static APINodeList<TargetingProductAudienceSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<TargetingProductAudienceSpec> targetingProductAudienceSpecs = new APINodeList<TargetingProductAudienceSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingProductAudienceSpecs;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        targetingProductAudienceSpecs.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingProductAudienceSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingProductAudienceSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingProductAudienceSpecs;
                }
                targetingProductAudienceSpecs.clear();
                targetingProductAudienceSpecs.add(TargetingProductAudienceSpec.loadJSON(json, context));
                return targetingProductAudienceSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingProductAudienceSpec.getGson().toJson((Object)this);
    }

    public List<TargetingProductAudienceSubSpec> getFieldExclusions() {
        return this.mExclusions;
    }

    public TargetingProductAudienceSpec setFieldExclusions(List<TargetingProductAudienceSubSpec> value) {
        this.mExclusions = value;
        return this;
    }

    public TargetingProductAudienceSpec setFieldExclusions(String value) {
        Type type = new TypeToken<List<TargetingProductAudienceSubSpec>>(){}.getType();
        this.mExclusions = (List)TargetingProductAudienceSubSpec.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingProductAudienceSubSpec> getFieldInclusions() {
        return this.mInclusions;
    }

    public TargetingProductAudienceSpec setFieldInclusions(List<TargetingProductAudienceSubSpec> value) {
        this.mInclusions = value;
        return this;
    }

    public TargetingProductAudienceSpec setFieldInclusions(String value) {
        Type type = new TypeToken<List<TargetingProductAudienceSubSpec>>(){}.getType();
        this.mInclusions = (List)TargetingProductAudienceSubSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public TargetingProductAudienceSpec setFieldProductSetId(String value) {
        this.mProductSetId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingProductAudienceSpec copyFrom(TargetingProductAudienceSpec instance) {
        this.mExclusions = instance.mExclusions;
        this.mInclusions = instance.mInclusions;
        this.mProductSetId = instance.mProductSetId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingProductAudienceSpec> getParser() {
        return new APIRequest.ResponseParser<TargetingProductAudienceSpec>(){

            @Override
            public APINodeList<TargetingProductAudienceSpec> parseResponse(String response, APIContext context, APIRequest<TargetingProductAudienceSpec> request) throws APIException.MalformedResponseException {
                return TargetingProductAudienceSpec.parseResponse(response, context, request);
            }
        };
    }
}

