/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Ad;
import com.facebook.ads.sdk.AdLabel;
import com.facebook.ads.sdk.AdRecommendation;
import com.facebook.ads.sdk.AdReportRun;
import com.facebook.ads.sdk.AdSet;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdsInsights;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Campaign
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="adlabels")
    private List<AdLabel> mAdlabels = null;
    @SerializedName(value="boosted_object_id")
    private String mBoostedObjectId = null;
    @SerializedName(value="brand_lift_studies")
    private List<AdStudy> mBrandLiftStudies = null;
    @SerializedName(value="budget_rebalance_flag")
    private Boolean mBudgetRebalanceFlag = null;
    @SerializedName(value="buying_type")
    private String mBuyingType = null;
    @SerializedName(value="can_create_brand_lift_study")
    private Boolean mCanCreateBrandLiftStudy = null;
    @SerializedName(value="can_use_spend_cap")
    private Boolean mCanUseSpendCap = null;
    @SerializedName(value="configured_status")
    private EnumConfiguredStatus mConfiguredStatus = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="effective_status")
    private EnumEffectiveStatus mEffectiveStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="kpi_custom_conversion_id")
    private String mKpiCustomConversionId = null;
    @SerializedName(value="kpi_type")
    private String mKpiType = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="objective")
    private String mObjective = null;
    @SerializedName(value="recommendations")
    private List<AdRecommendation> mRecommendations = null;
    @SerializedName(value="source_campaign")
    private Campaign mSourceCampaign = null;
    @SerializedName(value="source_campaign_id")
    private String mSourceCampaignId = null;
    @SerializedName(value="spend_cap")
    private String mSpendCap = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="stop_time")
    private String mStopTime = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    Campaign() {
    }

    public Campaign(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Campaign(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Campaign fetch() throws APIException {
        Campaign newInstance = Campaign.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Campaign fetchById(Long id, APIContext context) throws APIException {
        return Campaign.fetchById(id.toString(), context);
    }

    public static Campaign fetchById(String id, APIContext context) throws APIException {
        Campaign campaign = new APIRequestGet(id, context).requestAllFields().execute();
        return campaign;
    }

    public static APINodeList<Campaign> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Campaign>(context, "", "/", "GET", Campaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Campaign loadJSON(String json, APIContext context) {
        Campaign campaign = (Campaign)Campaign.getGson().fromJson(json, Campaign.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(campaign.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        campaign.context = context;
        campaign.rawValue = json;
        return campaign;
    }

    public static APINodeList<Campaign> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<Campaign> campaigns = new APINodeList<Campaign>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        campaigns.add(Campaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return campaigns;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        campaigns.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            campaigns.add(Campaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                campaigns.add(Campaign.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            campaigns.add(Campaign.loadJSON(obj.toString(), context));
                        }
                    }
                    return campaigns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        campaigns.add(Campaign.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return campaigns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        campaigns.add(Campaign.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return campaigns;
                }
                campaigns.clear();
                campaigns.add(Campaign.loadJSON(json, context));
                return campaigns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Campaign.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAdLabels deleteAdLabels() {
        return new APIRequestDeleteAdLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdLabel createAdLabel() {
        return new APIRequestCreateAdLabel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAds getAds() {
        return new APIRequestGetAds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdSets getAdSets() {
        return new APIRequestGetAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCopies getCopies() {
        return new APIRequestGetCopies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsightsAsync getInsightsAsync() {
        return new APIRequestGetInsightsAsync(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public List<AdLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public String getFieldBoostedObjectId() {
        return this.mBoostedObjectId;
    }

    public List<AdStudy> getFieldBrandLiftStudies() {
        return this.mBrandLiftStudies;
    }

    public Boolean getFieldBudgetRebalanceFlag() {
        return this.mBudgetRebalanceFlag;
    }

    public String getFieldBuyingType() {
        return this.mBuyingType;
    }

    public Boolean getFieldCanCreateBrandLiftStudy() {
        return this.mCanCreateBrandLiftStudy;
    }

    public Boolean getFieldCanUseSpendCap() {
        return this.mCanUseSpendCap;
    }

    public EnumConfiguredStatus getFieldConfiguredStatus() {
        return this.mConfiguredStatus;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public EnumEffectiveStatus getFieldEffectiveStatus() {
        return this.mEffectiveStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldKpiCustomConversionId() {
        return this.mKpiCustomConversionId;
    }

    public String getFieldKpiType() {
        return this.mKpiType;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObjective() {
        return this.mObjective;
    }

    public List<AdRecommendation> getFieldRecommendations() {
        return this.mRecommendations;
    }

    public Campaign getFieldSourceCampaign() {
        if (this.mSourceCampaign != null) {
            this.mSourceCampaign.context = this.getContext();
        }
        return this.mSourceCampaign;
    }

    public String getFieldSourceCampaignId() {
        return this.mSourceCampaignId;
    }

    public String getFieldSpendCap() {
        return this.mSpendCap;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStopTime() {
        return this.mStopTime;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Campaign copyFrom(Campaign instance) {
        this.mAccountId = instance.mAccountId;
        this.mAdlabels = instance.mAdlabels;
        this.mBoostedObjectId = instance.mBoostedObjectId;
        this.mBrandLiftStudies = instance.mBrandLiftStudies;
        this.mBudgetRebalanceFlag = instance.mBudgetRebalanceFlag;
        this.mBuyingType = instance.mBuyingType;
        this.mCanCreateBrandLiftStudy = instance.mCanCreateBrandLiftStudy;
        this.mCanUseSpendCap = instance.mCanUseSpendCap;
        this.mConfiguredStatus = instance.mConfiguredStatus;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEffectiveStatus = instance.mEffectiveStatus;
        this.mId = instance.mId;
        this.mKpiCustomConversionId = instance.mKpiCustomConversionId;
        this.mKpiType = instance.mKpiType;
        this.mName = instance.mName;
        this.mObjective = instance.mObjective;
        this.mRecommendations = instance.mRecommendations;
        this.mSourceCampaign = instance.mSourceCampaign;
        this.mSourceCampaignId = instance.mSourceCampaignId;
        this.mSpendCap = instance.mSpendCap;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mStopTime = instance.mStopTime;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Campaign> getParser() {
        return new APIRequest.ResponseParser<Campaign>(){

            @Override
            public APINodeList<Campaign> parseResponse(String response, APIContext context, APIRequest<Campaign> request) throws APIException.MalformedResponseException {
                return Campaign.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOperator {
        VALUE_ALL("ALL"),
        VALUE_ANY("ANY"),
        NULL(null);

        private String value;

        private EnumOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumObjective {
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_CONVERSIONS("CONVERSIONS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_REACH("REACH"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        NULL(null);

        private String value;

        private EnumObjective(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumExecutionOptions {
        VALUE_VALIDATE_ONLY("validate_only"),
        VALUE_INCLUDE_RECOMMENDATIONS("include_recommendations"),
        NULL(null);

        private String value;

        private EnumExecutionOptions(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDeleteStrategy {
        VALUE_DELETE_ANY("DELETE_ANY"),
        VALUE_DELETE_OLDEST("DELETE_OLDEST"),
        VALUE_DELETE_ARCHIVED_BEFORE("DELETE_ARCHIVED_BEFORE"),
        NULL(null);

        private String value;

        private EnumDeleteStrategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDatePreset {
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_LIFETIME("lifetime"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        NULL(null);

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_PAUSED("PAUSED"),
        VALUE_DELETED("DELETED"),
        VALUE_ARCHIVED("ARCHIVED"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEffectiveStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_PAUSED("PAUSED"),
        VALUE_DELETED("DELETED"),
        VALUE_PENDING_REVIEW("PENDING_REVIEW"),
        VALUE_DISAPPROVED("DISAPPROVED"),
        VALUE_PREAPPROVED("PREAPPROVED"),
        VALUE_PENDING_BILLING_INFO("PENDING_BILLING_INFO"),
        VALUE_CAMPAIGN_PAUSED("CAMPAIGN_PAUSED"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_ADSET_PAUSED("ADSET_PAUSED"),
        NULL(null);

        private String value;

        private EnumEffectiveStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumConfiguredStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_PAUSED("PAUSED"),
        VALUE_DELETED("DELETED"),
        VALUE_ARCHIVED("ARCHIVED"),
        NULL(null);

        private String value;

        private EnumConfiguredStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels", "budget_rebalance_flag", "execution_options", "name", "objective", "promoted_object", "spend_cap", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setBudgetRebalanceFlag(Boolean budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestUpdate setBudgetRebalanceFlag(String budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestUpdate setExecutionOptions(List<EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestUpdate setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setObjective(EnumObjective objective) {
            this.setParam("objective", (Object)objective);
            return this;
        }

        public APIRequestUpdate setObjective(String objective) {
            this.setParam("objective", objective);
            return this;
        }

        public APIRequestUpdate setPromotedObject(Object promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestUpdate setPromotedObject(String promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestUpdate setSpendCap(Long spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setSpendCap(String spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "buying_type", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "effective_status", "id", "kpi_custom_conversion_id", "kpi_type", "name", "objective", "recommendations", "source_campaign", "source_campaign_id", "spend_cap", "start_time", "status", "stop_time", "updated_time"};

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGet requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGet requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGet requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGet requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGet requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGet requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGet requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGet requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGet requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGet requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGet requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGet requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGet requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGet requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGet requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGet requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestKpiCustomConversionIdField() {
            return this.requestKpiCustomConversionIdField(true);
        }

        public APIRequestGet requestKpiCustomConversionIdField(boolean value) {
            this.requestField("kpi_custom_conversion_id", value);
            return this;
        }

        public APIRequestGet requestKpiTypeField() {
            return this.requestKpiTypeField(true);
        }

        public APIRequestGet requestKpiTypeField(boolean value) {
            this.requestField("kpi_type", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGet requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGet requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGet requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGet requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGet requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGet requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGet requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGet requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGet requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGet requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsightsAsync
    extends APIRequest<AdReportRun> {
        APINodeList<AdReportRun> lastResponse = null;
        public static final String[] PARAMS = new String[]{"action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "default_summary", "export_columns", "export_format", "export_name", "fields", "filtering", "level", "product_id_limit", "sort", "summary", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<AdReportRun> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdReportRun> parseResponse(String response) throws APIException {
            return AdReportRun.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdReportRun> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdReportRun> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetInsightsAsync(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsightsAsync setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsightsAsync setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(List<AdsInsights.EnumSummary> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(List<AdsInsights.EnumSummary> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(List<Object> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsightsAsync requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<AdsInsights> {
        APINodeList<AdsInsights> lastResponse = null;
        public static final String[] PARAMS = new String[]{"action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "default_summary", "export_columns", "export_format", "export_name", "fields", "filtering", "level", "product_id_limit", "sort", "summary", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<AdsInsights> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsInsights> parseResponse(String response) throws APIException {
            return AdsInsights.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsInsights> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsInsights> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsights setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsights setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsights setFields(List<AdsInsights.EnumSummary> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsights setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setSummary(List<AdsInsights.EnumSummary> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsights setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(List<Object> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCopies
    extends APIRequest<Campaign> {
        APINodeList<Campaign> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "effective_status", "is_completed", "time_range"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "buying_type", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "effective_status", "id", "kpi_custom_conversion_id", "kpi_type", "name", "objective", "recommendations", "source_campaign", "source_campaign_id", "spend_cap", "start_time", "status", "stop_time", "updated_time"};

        @Override
        public APINodeList<Campaign> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Campaign> parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Campaign> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Campaign> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetCopies(String nodeId, APIContext context) {
            super(context, nodeId, "/copies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCopies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCopies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCopies setDatePreset(EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetCopies setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetCopies setEffectiveStatus(List<EnumEffectiveStatus> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCopies setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCopies setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCopies setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCopies setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetCopies setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetCopies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCopies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCopies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCopies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCopies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCopies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCopies requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCopies requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCopies requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetCopies requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetCopies requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGetCopies requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGetCopies requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGetCopies requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGetCopies requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGetCopies requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGetCopies requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGetCopies requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGetCopies requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGetCopies requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGetCopies requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGetCopies requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGetCopies requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetCopies requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetCopies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetCopies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetCopies requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetCopies requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetCopies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCopies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCopies requestKpiCustomConversionIdField() {
            return this.requestKpiCustomConversionIdField(true);
        }

        public APIRequestGetCopies requestKpiCustomConversionIdField(boolean value) {
            this.requestField("kpi_custom_conversion_id", value);
            return this;
        }

        public APIRequestGetCopies requestKpiTypeField() {
            return this.requestKpiTypeField(true);
        }

        public APIRequestGetCopies requestKpiTypeField(boolean value) {
            this.requestField("kpi_type", value);
            return this;
        }

        public APIRequestGetCopies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCopies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCopies requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGetCopies requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGetCopies requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetCopies requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetCopies requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGetCopies requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGetCopies requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGetCopies requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGetCopies requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetCopies requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetCopies requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetCopies requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetCopies requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetCopies requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetCopies requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGetCopies requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGetCopies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetCopies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdSets
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_draft_id", "date_preset", "effective_status", "is_completed", "time_range"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "adset_schedule", "attribution_spec", "bid_amount", "bid_info", "billing_event", "budget_remaining", "campaign", "campaign_id", "configured_status", "created_time", "creative_sequence", "daily_budget", "destination_type", "effective_status", "end_time", "frequency_control_specs", "id", "instagram_actor_id", "is_autobid", "is_average_price_pacing", "lifetime_budget", "lifetime_imps", "name", "optimization_goal", "pacing_type", "promoted_object", "recommendations", "recurring_budget_semantics", "rf_prediction_id", "rtb_flag", "source_adset", "source_adset_id", "start_time", "status", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "updated_time", "use_new_app_click"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetAdSets(String nodeId, APIContext context) {
            super(context, nodeId, "/adsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdSets setAdDraftId(String adDraftId) {
            this.setParam("ad_draft_id", adDraftId);
            return this;
        }

        public APIRequestGetAdSets setDatePreset(AdSet.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetAdSets setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetAdSets setEffectiveStatus(List<AdSet.EnumEffectiveStatus> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAdSets setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAdSets setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAdSets setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAdSets setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAdSets setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAdSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdSets requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAdSets requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAdSets requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetAdSets requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetAdSets requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdSets requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdSets requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAdSets requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAdSets requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAdSets requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAdSets requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetAdSets requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetAdSets requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetAdSets requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAdSets requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAdSets requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAdSets requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAdSets requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAdSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdSets requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetAdSets requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetAdSets requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetAdSets requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetAdSets requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetAdSets requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAdSets requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAdSets requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdSets requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetAdSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdSets requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGetAdSets requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGetAdSets requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetAdSets requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetAdSets requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetAdSets requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetAdSets requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetAdSets requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetAdSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdSets requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetAdSets requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetAdSets requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetAdSets requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetAdSets requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetAdSets requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetAdSets requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAdSets requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetAdSets requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetAdSets requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetAdSets requestRtbFlagField() {
            return this.requestRtbFlagField(true);
        }

        public APIRequestGetAdSets requestRtbFlagField(boolean value) {
            this.requestField("rtb_flag", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetAdSets requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdSets requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdSets requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdSets requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdSets requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAdSets requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetAdSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAdSets requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetAdSets requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAds
    extends APIRequest<Ad> {
        APINodeList<Ad> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_draft_id", "date_preset", "effective_status", "include_deleted", "time_range", "updated_since"};
        public static final String[] FIELDS = new String[]{"account_id", "ad_review_feedback", "adlabels", "adset", "adset_id", "bid_amount", "bid_info", "bid_type", "campaign", "campaign_id", "configured_status", "conversion_specs", "created_time", "creative", "effective_status", "id", "last_updated_by_app_id", "name", "recommendations", "source_ad", "source_ad_id", "status", "tracking_specs", "updated_time"};

        @Override
        public APINodeList<Ad> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Ad> parseResponse(String response) throws APIException {
            return Ad.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Ad> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Ad> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetAds(String nodeId, APIContext context) {
            super(context, nodeId, "/ads", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAds setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAds setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAds setAdDraftId(String adDraftId) {
            this.setParam("ad_draft_id", adDraftId);
            return this;
        }

        public APIRequestGetAds setDatePreset(Ad.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetAds setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(List<String> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setIncludeDeleted(Boolean includeDeleted) {
            this.setParam("include_deleted", includeDeleted);
            return this;
        }

        public APIRequestGetAds setIncludeDeleted(String includeDeleted) {
            this.setParam("include_deleted", includeDeleted);
            return this;
        }

        public APIRequestGetAds setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAds setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAds setUpdatedSince(Long updatedSince) {
            this.setParam("updated_since", updatedSince);
            return this;
        }

        public APIRequestGetAds setUpdatedSince(String updatedSince) {
            this.setParam("updated_since", updatedSince);
            return this;
        }

        public APIRequestGetAds requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAds requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAds requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAds requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAds requestAdReviewFeedbackField() {
            return this.requestAdReviewFeedbackField(true);
        }

        public APIRequestGetAds requestAdReviewFeedbackField(boolean value) {
            this.requestField("ad_review_feedback", value);
            return this;
        }

        public APIRequestGetAds requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAds requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAds requestAdsetField() {
            return this.requestAdsetField(true);
        }

        public APIRequestGetAds requestAdsetField(boolean value) {
            this.requestField("adset", value);
            return this;
        }

        public APIRequestGetAds requestAdsetIdField() {
            return this.requestAdsetIdField(true);
        }

        public APIRequestGetAds requestAdsetIdField(boolean value) {
            this.requestField("adset_id", value);
            return this;
        }

        public APIRequestGetAds requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAds requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAds requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAds requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAds requestBidTypeField() {
            return this.requestBidTypeField(true);
        }

        public APIRequestGetAds requestBidTypeField(boolean value) {
            this.requestField("bid_type", value);
            return this;
        }

        public APIRequestGetAds requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAds requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAds requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAds requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAds requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAds requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAds requestConversionSpecsField() {
            return this.requestConversionSpecsField(true);
        }

        public APIRequestGetAds requestConversionSpecsField(boolean value) {
            this.requestField("conversion_specs", value);
            return this;
        }

        public APIRequestGetAds requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAds requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAds requestCreativeField() {
            return this.requestCreativeField(true);
        }

        public APIRequestGetAds requestCreativeField(boolean value) {
            this.requestField("creative", value);
            return this;
        }

        public APIRequestGetAds requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAds requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAds requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAds requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField() {
            return this.requestLastUpdatedByAppIdField(true);
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField(boolean value) {
            this.requestField("last_updated_by_app_id", value);
            return this;
        }

        public APIRequestGetAds requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAds requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAds requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAds requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdField() {
            return this.requestSourceAdField(true);
        }

        public APIRequestGetAds requestSourceAdField(boolean value) {
            this.requestField("source_ad", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdIdField() {
            return this.requestSourceAdIdField(true);
        }

        public APIRequestGetAds requestSourceAdIdField(boolean value) {
            this.requestField("source_ad_id", value);
            return this;
        }

        public APIRequestGetAds requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAds requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAds requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetAds requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetAds requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAds requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdLabel
    extends APIRequest<AdLabel> {
        AdLabel lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels", "execution_options"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdLabel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdLabel parseResponse(String response) throws APIException {
            return AdLabel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdLabel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdLabel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateAdLabel(String nodeId, APIContext context) {
            super(context, nodeId, "/adlabels", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdLabel setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel setExecutionOptions(List<AdLabel.EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateAdLabel setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateAdLabel requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdLabel requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdLabels
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels", "execution_options"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDeleteAdLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/adlabels", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdLabels setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDeleteAdLabels setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDeleteAdLabels setExecutionOptions(List<AdLabel.EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestDeleteAdLabels setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestDeleteAdLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

