/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdPromotedObject
extends APINode {
    @SerializedName(value="application_id")
    private String mApplicationId = null;
    @SerializedName(value="custom_event_type")
    private EnumCustomEventType mCustomEventType = null;
    @SerializedName(value="event_id")
    private String mEventId = null;
    @SerializedName(value="object_store_url")
    private String mObjectStoreUrl = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    @SerializedName(value="place_page_set_id")
    private String mPlacePageSetId = null;
    @SerializedName(value="product_catalog_id")
    private String mProductCatalogId = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdPromotedObject loadJSON(String json, APIContext context) {
        AdPromotedObject adPromotedObject = (AdPromotedObject)AdPromotedObject.getGson().fromJson(json, AdPromotedObject.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPromotedObject.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPromotedObject.context = context;
        adPromotedObject.rawValue = json;
        return adPromotedObject;
    }

    public static APINodeList<AdPromotedObject> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdPromotedObject> adPromotedObjects = new APINodeList<AdPromotedObject>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adPromotedObjects;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adPromotedObjects.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(obj.toString(), context));
                        }
                    }
                    return adPromotedObjects;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adPromotedObjects;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPromotedObjects;
                }
                adPromotedObjects.clear();
                adPromotedObjects.add(AdPromotedObject.loadJSON(json, context));
                return adPromotedObjects;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPromotedObject.getGson().toJson((Object)this);
    }

    public String getFieldApplicationId() {
        return this.mApplicationId;
    }

    public AdPromotedObject setFieldApplicationId(String value) {
        this.mApplicationId = value;
        return this;
    }

    public EnumCustomEventType getFieldCustomEventType() {
        return this.mCustomEventType;
    }

    public AdPromotedObject setFieldCustomEventType(EnumCustomEventType value) {
        this.mCustomEventType = value;
        return this;
    }

    public String getFieldEventId() {
        return this.mEventId;
    }

    public AdPromotedObject setFieldEventId(String value) {
        this.mEventId = value;
        return this;
    }

    public String getFieldObjectStoreUrl() {
        return this.mObjectStoreUrl;
    }

    public AdPromotedObject setFieldObjectStoreUrl(String value) {
        this.mObjectStoreUrl = value;
        return this;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public AdPromotedObject setFieldOfferId(String value) {
        this.mOfferId = value;
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public AdPromotedObject setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public AdPromotedObject setFieldPixelId(String value) {
        this.mPixelId = value;
        return this;
    }

    public String getFieldPlacePageSetId() {
        return this.mPlacePageSetId;
    }

    public AdPromotedObject setFieldPlacePageSetId(String value) {
        this.mPlacePageSetId = value;
        return this;
    }

    public String getFieldProductCatalogId() {
        return this.mProductCatalogId;
    }

    public AdPromotedObject setFieldProductCatalogId(String value) {
        this.mProductCatalogId = value;
        return this;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public AdPromotedObject setFieldProductSetId(String value) {
        this.mProductSetId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPromotedObject copyFrom(AdPromotedObject instance) {
        this.mApplicationId = instance.mApplicationId;
        this.mCustomEventType = instance.mCustomEventType;
        this.mEventId = instance.mEventId;
        this.mObjectStoreUrl = instance.mObjectStoreUrl;
        this.mOfferId = instance.mOfferId;
        this.mPageId = instance.mPageId;
        this.mPixelId = instance.mPixelId;
        this.mPlacePageSetId = instance.mPlacePageSetId;
        this.mProductCatalogId = instance.mProductCatalogId;
        this.mProductSetId = instance.mProductSetId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPromotedObject> getParser() {
        return new APIRequest.ResponseParser<AdPromotedObject>(){

            @Override
            public APINodeList<AdPromotedObject> parseResponse(String response, APIContext context, APIRequest<AdPromotedObject> request) throws APIException.MalformedResponseException {
                return AdPromotedObject.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCustomEventType {
        VALUE_COMPLETE_REGISTRATION("COMPLETE_REGISTRATION"),
        VALUE_CONTENT_VIEW("CONTENT_VIEW"),
        VALUE_SEARCH("SEARCH"),
        VALUE_RATE("RATE"),
        VALUE_TUTORIAL_COMPLETION("TUTORIAL_COMPLETION"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_ADD_TO_WISHLIST("ADD_TO_WISHLIST"),
        VALUE_INITIATED_CHECKOUT("INITIATED_CHECKOUT"),
        VALUE_ADD_PAYMENT_INFO("ADD_PAYMENT_INFO"),
        VALUE_PURCHASE("PURCHASE"),
        VALUE_LEAD("LEAD"),
        VALUE_LEVEL_ACHIEVED("LEVEL_ACHIEVED"),
        VALUE_ACHIEVEMENT_UNLOCKED("ACHIEVEMENT_UNLOCKED"),
        VALUE_SPENT_CREDITS("SPENT_CREDITS"),
        VALUE_OTHER("OTHER"),
        NULL(null);

        private String value;

        private EnumCustomEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

