/*
 * Decompiled with CFR 0.152.
 */
package com.faber.circlestepview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.faber.circlestepview.R;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CircleStepView
extends View {
    private int DEF_CIRCLE_RADIUS_DP = 20;
    private int DEF_PATH_HEIGHT_DP = 10;
    private int DEF_TEXT_SIZE_SP = 14;
    private int DEF_CURRENT_CIRCLE_DELTA_RADIUS_DP = 2;
    private int DEF_TEXT_BELOW_CIRCLE_DISTANCE_DP = 3;
    private int mCircleRadius;
    private int mCircleColor;
    private int mCircleCount;
    private int mCircleTextSize;
    private int mCircleTextColor;
    private int mCurrentCircleDeltaRadius;
    private int mCurrentInnerCircleColor;
    private int mCurrentOuterCircleColor;
    private int mPathHeight;
    private int mPathColor;
    private int mTextBelowCircleDistance;
    private int mTextBelowCircleSize;
    private int mTextBelowCircleColor;
    private int mPathWidth;
    private Rect mPathRect;
    private int mCircleCenterDelta;
    private List<Point> mCircleCenterList = new ArrayList<Point>();
    private int mCircleTextShiftHeight;
    private int mCurrentCircleIndex = 0;
    private int mPreCircleIndex = 0;
    private List<String> mTextBelowCircleList;
    private int mTextBelowCircleShiftHeight;
    private float mCurrentCircleRadiusRatio = 1.0f;
    private float mPreCircleRadiusRatio = 0.0f;
    private Paint mCirclePaint = new Paint(5);
    private Paint mCircleTextPaint = new Paint(5);
    private Paint mCurrentCirclePaint = new Paint(5);
    private Paint mPathPaint = new Paint(5);
    private Paint mTextBelowCirclePaint = new Paint(5);

    public CircleStepView(Context context) {
        this(context, null);
    }

    public CircleStepView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircleStepView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.circlestep_CircleStepView, defStyleAttr, 0);
        if (attributes != null) {
            try {
                this.mCircleRadius = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_circle_radius, TypedValue.applyDimension((int)1, (float)this.DEF_CIRCLE_RADIUS_DP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mCircleColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_circle_color, -7829368);
                this.mCircleCount = attributes.getInt(R.styleable.circlestep_CircleStepView_circlestep_circle_count, 3);
                this.mCircleTextSize = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_circle_text_size, TypedValue.applyDimension((int)2, (float)this.DEF_TEXT_SIZE_SP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mCircleTextColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_circle_text_color, -1);
                this.mCurrentCircleDeltaRadius = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_current_circle_delta_radius, TypedValue.applyDimension((int)1, (float)this.DEF_CURRENT_CIRCLE_DELTA_RADIUS_DP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mCurrentInnerCircleColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_current_inner_circle_color, -16776961);
                this.mCurrentOuterCircleColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_current_outer_circle_color, -16711936);
                this.mPathHeight = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_path_height, TypedValue.applyDimension((int)1, (float)this.DEF_PATH_HEIGHT_DP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mPathColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_path_color, -16711936);
                this.mTextBelowCircleDistance = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_text_below_circle_distance, TypedValue.applyDimension((int)1, (float)this.DEF_TEXT_BELOW_CIRCLE_DISTANCE_DP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mTextBelowCircleSize = (int)attributes.getDimension(R.styleable.circlestep_CircleStepView_circlestep_text_below_circle_size, TypedValue.applyDimension((int)2, (float)this.DEF_TEXT_SIZE_SP, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mTextBelowCircleColor = attributes.getColor(R.styleable.circlestep_CircleStepView_circlestep_text_below_circle_color, -16777216);
            }
            finally {
                attributes.recycle();
            }
        }
        this.mCircleCount = this.mCircleCount < 2 ? 2 : this.mCircleCount;
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCircleTextPaint.setTextSize((float)this.mCircleTextSize);
        this.mCircleTextPaint.setColor(this.mCircleTextColor);
        this.mCircleTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mCircleTextShiftHeight = (int)(-this.mCircleTextPaint.descent() - this.mCircleTextPaint.ascent()) / 2;
        this.mPathPaint.setStyle(Paint.Style.FILL);
        this.mPathPaint.setColor(this.mPathColor);
        this.mTextBelowCirclePaint.setTextSize((float)this.mTextBelowCircleSize);
        this.mTextBelowCirclePaint.setColor(this.mTextBelowCircleColor);
        this.mTextBelowCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mTextBelowCircleShiftHeight = (int)(this.mTextBelowCirclePaint.descent() - this.mTextBelowCirclePaint.ascent());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            width = this.getSuggestedMinimumWidth();
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(width, widthSize);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.getPaddingTop() + 2 * this.mCircleRadius + this.mTextBelowCircleDistance + this.mTextBelowCircleSize + this.getPaddingBottom();
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mPathWidth = w - this.getPaddingLeft() - this.getPaddingRight() - 2 * this.mCircleRadius;
        this.mCircleCenterDelta = this.mPathWidth / (this.mCircleCount - 1);
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        this.mPathRect = new Rect(paddingLeft + this.mCircleRadius, paddingTop + this.mCircleRadius - this.mPathHeight / 2, paddingLeft + this.mCircleRadius + this.mPathWidth, paddingTop + this.mCircleRadius + this.mPathHeight / 2);
        int py = paddingTop + this.mCircleRadius;
        for (int i = 0; i < this.mCircleCount; ++i) {
            int px = paddingLeft + this.mCircleRadius + i * this.mCircleCenterDelta;
            this.mCircleCenterList.add(i, new Point(px, py));
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.drawRect(this.mPathRect, this.mPathPaint);
        canvas.restore();
        for (int i = 0; i < this.mCircleCount; ++i) {
            Point centerPoint = this.mCircleCenterList.get(i);
            canvas.save();
            canvas.drawCircle((float)centerPoint.x, (float)centerPoint.y, (float)this.mCircleRadius, this.mCirclePaint);
            canvas.restore();
            canvas.save();
            if (i == this.mCurrentCircleIndex) {
                int currentOuterCircleRadius = (int)(this.mCurrentCircleRadiusRatio * (float)this.mCircleRadius);
                this.mCurrentCirclePaint.setColor(this.mCurrentOuterCircleColor);
                canvas.drawCircle((float)centerPoint.x, (float)centerPoint.y, (float)currentOuterCircleRadius, this.mCurrentCirclePaint);
                int currentInnerCircleRadius = (int)(this.mCurrentCircleRadiusRatio * (float)(this.mCircleRadius - this.mCurrentCircleDeltaRadius));
                this.mCurrentCirclePaint.setColor(this.mCurrentInnerCircleColor);
                canvas.drawCircle((float)centerPoint.x, (float)centerPoint.y, (float)currentInnerCircleRadius, this.mCurrentCirclePaint);
            } else if (i == this.mPreCircleIndex) {
                int preOuterCircleRadius = (int)(this.mPreCircleRadiusRatio * (float)this.mCircleRadius);
                this.mCurrentCirclePaint.setColor(this.mCurrentOuterCircleColor);
                canvas.drawCircle((float)centerPoint.x, (float)centerPoint.y, (float)preOuterCircleRadius, this.mCurrentCirclePaint);
                int preInnerCircleRadius = (int)(this.mPreCircleRadiusRatio * (float)(this.mCircleRadius - this.mCurrentCircleDeltaRadius));
                this.mCurrentCirclePaint.setColor(this.mCurrentInnerCircleColor);
                canvas.drawCircle((float)centerPoint.x, (float)centerPoint.y, (float)preInnerCircleRadius, this.mCurrentCirclePaint);
            }
            canvas.restore();
            canvas.save();
            String index = i + 1 + "";
            canvas.drawText(index, (float)centerPoint.x, (float)(centerPoint.y + this.mCircleTextShiftHeight), this.mCircleTextPaint);
            canvas.restore();
            canvas.save();
            canvas.drawText(this.getTextBelowCircleByIndex(i), (float)centerPoint.x, (float)(centerPoint.y + this.mCircleRadius + this.mTextBelowCircleDistance + this.mTextBelowCircleShiftHeight), this.mTextBelowCirclePaint);
            canvas.restore();
        }
    }

    public void setCurrentCircleIndex(int index, boolean isShowAnim) {
        this.mPreCircleIndex = this.mCurrentCircleIndex;
        this.mCurrentCircleIndex = index;
        this.mCurrentCircleIndex = this.mCurrentCircleIndex < 0 ? 0 : this.mCurrentCircleIndex;
        int n = this.mCurrentCircleIndex = this.mCurrentCircleIndex >= this.mCircleCount ? this.mCircleCount - 1 : this.mCurrentCircleIndex;
        if (this.mCurrentCircleIndex == this.mPreCircleIndex) {
            return;
        }
        if (!isShowAnim) {
            this.invalidate();
        } else {
            PropertyValuesHolder pvhHide = PropertyValuesHolder.ofFloat((String)"preCircleRadiusRatio", (float[])new float[]{1.0f, 0.0f});
            PropertyValuesHolder pvhShow = PropertyValuesHolder.ofFloat((String)"currentCircleRadiusRatio", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhHide, pvhShow});
            anim.setDuration(200L);
            anim.start();
        }
    }

    public int getCurrentCircleIndex() {
        return this.mCurrentCircleIndex;
    }

    public void setPreCircleRadiusRatio(float preCircleRadiusRatio) {
        this.mPreCircleRadiusRatio = preCircleRadiusRatio;
        this.mPreCircleRadiusRatio = this.mPreCircleRadiusRatio > 1.0f ? 1.0f : this.mPreCircleRadiusRatio;
        this.mPreCircleRadiusRatio = this.mPreCircleRadiusRatio < 0.0f ? 0.0f : this.mPreCircleRadiusRatio;
        this.invalidate();
    }

    public void setCurrentCircleRadiusRatio(float currentCircleRadiusRatio) {
        this.mCurrentCircleRadiusRatio = currentCircleRadiusRatio;
        this.mCurrentCircleRadiusRatio = this.mCurrentCircleRadiusRatio > 1.0f ? 1.0f : this.mCurrentCircleRadiusRatio;
        this.mCurrentCircleRadiusRatio = this.mCurrentCircleRadiusRatio < 0.0f ? 0.0f : this.mCurrentCircleRadiusRatio;
        this.invalidate();
    }

    private String getTextBelowCircleByIndex(int index) {
        String result = "";
        if (this.mTextBelowCircleList == null || this.mTextBelowCircleList.isEmpty() || this.mTextBelowCircleList.size() <= index) {
            return result;
        }
        result = this.mTextBelowCircleList.get(index);
        return result;
    }

    public void setTextBelowCircle(String ... strings) {
        this.mTextBelowCircleList = Arrays.asList(strings);
        this.invalidate();
    }
}

