/*
 * Decompiled with CFR 0.152.
 */
package com.f2prateek.rx.preferences2;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.f2prateek.rx.preferences2.Preconditions;
import com.f2prateek.rx.preferences2.Preference;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;

final class RealPreference<T>
implements Preference<T> {
    private final SharedPreferences preferences;
    private final String key;
    private final T defaultValue;
    private final Adapter<T> adapter;
    private final Observable<T> values;

    RealPreference(SharedPreferences preferences, final String key, T defaultValue, Adapter<T> adapter, Observable<String> keyChanges) {
        this.preferences = preferences;
        this.key = key;
        this.defaultValue = defaultValue;
        this.adapter = adapter;
        this.values = keyChanges.filter((Predicate)new Predicate<String>(){

            public boolean test(String changedKey) throws Exception {
                return key.equals(changedKey);
            }
        }).startWith((Object)"<init>").map(new Function<String, T>(){

            public T apply(String s) throws Exception {
                return RealPreference.this.get();
            }
        });
    }

    @Override
    @NonNull
    public String key() {
        return this.key;
    }

    @Override
    @NonNull
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    @NonNull
    public synchronized T get() {
        if (!this.preferences.contains(this.key)) {
            return this.defaultValue;
        }
        return this.adapter.get(this.key, this.preferences);
    }

    @Override
    public void set(@NonNull T value) {
        Preconditions.checkNotNull(value, "value == null");
        SharedPreferences.Editor editor = this.preferences.edit();
        this.adapter.set(this.key, value, editor);
        editor.apply();
    }

    @Override
    public boolean isSet() {
        return this.preferences.contains(this.key);
    }

    @Override
    public synchronized void delete() {
        this.preferences.edit().remove(this.key).apply();
    }

    @Override
    @CheckResult
    @NonNull
    public Observable<T> asObservable() {
        return this.values;
    }

    @Override
    @CheckResult
    @NonNull
    public Consumer<? super T> asConsumer() {
        return new Consumer<T>(){

            public void accept(T value) throws Exception {
                RealPreference.this.set(value);
            }
        };
    }

    static interface Adapter<T> {
        public T get(@NonNull String var1, @NonNull SharedPreferences var2);

        public void set(@NonNull String var1, @NonNull T var2, @NonNull SharedPreferences.Editor var3);
    }
}

