/*
 * Decompiled with CFR 0.152.
 */
package com.f2prateek.rx.preferences2;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.f2prateek.rx.preferences2.Preconditions;
import com.f2prateek.rx.preferences2.Preference;
import com.f2prateek.rx.preferences2.RealPreference;

final class ConverterAdapter<T>
implements RealPreference.Adapter<T> {
    private final Preference.Converter<T> converter;

    ConverterAdapter(Preference.Converter<T> converter) {
        this.converter = converter;
    }

    @Override
    public T get(@NonNull String key, @NonNull SharedPreferences preferences) {
        String serialized = preferences.getString(key, null);
        assert (serialized != null);
        T value = this.converter.deserialize(serialized);
        Preconditions.checkNotNull(value, "Deserialized value must not be null from string: " + serialized);
        return value;
    }

    @Override
    public void set(@NonNull String key, @NonNull T value, @NonNull SharedPreferences.Editor editor) {
        String serialized = this.converter.serialize(value);
        Preconditions.checkNotNull(serialized, "Serialized string must not be null from value: " + value);
        editor.putString(key, serialized);
    }
}

