/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import java.util.Locale;

class TouchPoint {
    private float x;
    private float y;

    public TouchPoint() {
    }

    public TouchPoint(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getLength() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public TouchPoint copy(TouchPoint other) {
        this.x = other.getX();
        this.y = other.getY();
        return this;
    }

    public TouchPoint set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public TouchPoint add(TouchPoint value) {
        this.x += value.getX();
        this.y += value.getY();
        return this;
    }

    public static TouchPoint subtract(TouchPoint lhs, TouchPoint rhs) {
        return new TouchPoint(lhs.x - rhs.x, lhs.y - rhs.y);
    }

    public String toString() {
        return String.format(Locale.US, "(%.4f, %.4f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

