/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.lyft.android.scissors.BitmapLoader;
import com.lyft.android.scissors.CropView;
import com.lyft.android.scissors.CropViewExtensions;
import com.lyft.android.scissors.Utils;

public class LoadRequest {
    private final CropView cropView;
    private BitmapLoader bitmapLoader;

    LoadRequest(CropView cropView) {
        Utils.checkNotNull((Object)cropView, "cropView == null");
        this.cropView = cropView;
    }

    public LoadRequest using(@Nullable BitmapLoader bitmapLoader) {
        this.bitmapLoader = bitmapLoader;
        return this;
    }

    public void load(@Nullable Object model) {
        if (this.cropView.getWidth() == 0 && this.cropView.getHeight() == 0) {
            this.deferLoad(model);
            return;
        }
        this.performLoad(model);
    }

    void performLoad(Object model) {
        if (this.bitmapLoader == null) {
            this.bitmapLoader = CropViewExtensions.resolveBitmapLoader(this.cropView);
        }
        this.bitmapLoader.load(model, this.cropView);
    }

    void deferLoad(final Object model) {
        if (!this.cropView.getViewTreeObserver().isAlive()) {
            return;
        }
        this.cropView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (LoadRequest.this.cropView.getViewTreeObserver().isAlive()) {
                    LoadRequest.this.cropView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                LoadRequest.this.performLoad(model);
            }
        });
    }
}

