/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.graphics.Bitmap;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.lyft.android.scissors.CropViewExtensions;
import java.nio.charset.Charset;
import java.security.MessageDigest;

class GlideFillViewportTransformation
extends BitmapTransformation {
    private static final String ID = "com.lyft.android.scissors.GlideFillViewportTransformation";
    private static final byte[] ID_BYTES = "com.lyft.android.scissors.GlideFillViewportTransformation".getBytes(Charset.defaultCharset());
    private final int viewportWidth;
    private final int viewportHeight;

    public GlideFillViewportTransformation(int viewportWidth, int viewportHeight) {
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
    }

    protected Bitmap transform(@NonNull BitmapPool bitmapPool, @NonNull Bitmap source, int outWidth, int outHeight) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        Rect target = CropViewExtensions.computeTargetSize(sourceWidth, sourceHeight, this.viewportWidth, this.viewportHeight);
        int targetWidth = target.width();
        int targetHeight = target.height();
        return Bitmap.createScaledBitmap((Bitmap)source, (int)targetWidth, (int)targetHeight, (boolean)true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlideFillViewportTransformation) {
            GlideFillViewportTransformation other = (GlideFillViewportTransformation)((Object)obj);
            return other.viewportWidth == this.viewportWidth && other.viewportHeight == this.viewportHeight;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.viewportWidth * 31 + this.viewportHeight;
        return hash * 17 + ID.hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
    }

    public static BitmapTransformation createUsing(int viewportWidth, int viewportHeight) {
        return new GlideFillViewportTransformation(viewportWidth, viewportHeight);
    }
}

