/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.android.scissors;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lyft.android.scissors.BitmapLoader;
import com.lyft.android.scissors.CropRequest;
import com.lyft.android.scissors.CropViewConfig;
import com.lyft.android.scissors.CropViewExtensions;
import com.lyft.android.scissors.LoadRequest;
import com.lyft.android.scissors.TouchManager;
import com.lyft.android.scissors.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CropView
extends ImageView {
    private TouchManager touchManager;
    private CropViewConfig config;
    private Paint viewportPaint = new Paint();
    private Paint bitmapPaint = new Paint();
    private Bitmap bitmap;
    private Matrix transform = new Matrix();
    private Extensions extensions;
    private int shape = 0;
    private Path ovalPath;
    private RectF ovalRect;

    public CropView(Context context) {
        super(context);
        this.initCropView(context, null);
    }

    public CropView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCropView(context, attrs);
    }

    void initCropView(Context context, AttributeSet attrs) {
        this.config = CropViewConfig.from(context, attrs);
        this.touchManager = new TouchManager(this, this.config);
        this.bitmapPaint.setFilterBitmap(true);
        this.setViewportOverlayColor(this.config.getViewportOverlayColor());
        this.shape = this.config.shape();
        this.viewportPaint.setFlags(this.viewportPaint.getFlags() | 1);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bitmap == null) {
            return;
        }
        this.drawBitmap(canvas);
        if (this.shape == 0) {
            this.drawSquareOverlay(canvas);
        } else {
            this.drawOvalOverlay(canvas);
        }
    }

    private void drawBitmap(Canvas canvas) {
        this.transform.reset();
        this.touchManager.applyPositioningAndScale(this.transform);
        canvas.drawBitmap(this.bitmap, this.transform, this.bitmapPaint);
    }

    private void drawSquareOverlay(Canvas canvas) {
        int viewportWidth = this.touchManager.getViewportWidth();
        int viewportHeight = this.touchManager.getViewportHeight();
        int left = (this.getWidth() - viewportWidth) / 2;
        int top = (this.getHeight() - viewportHeight) / 2;
        canvas.drawRect(0.0f, (float)top, (float)left, (float)(this.getHeight() - top), this.viewportPaint);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)top, this.viewportPaint);
        canvas.drawRect((float)(this.getWidth() - left), (float)top, (float)this.getWidth(), (float)(this.getHeight() - top), this.viewportPaint);
        canvas.drawRect(0.0f, (float)(this.getHeight() - top), (float)this.getWidth(), (float)this.getHeight(), this.viewportPaint);
    }

    private void drawOvalOverlay(Canvas canvas) {
        if (this.ovalRect == null) {
            this.ovalRect = new RectF();
        }
        if (this.ovalPath == null) {
            this.ovalPath = new Path();
        }
        int viewportWidth = this.touchManager.getViewportWidth();
        int viewportHeight = this.touchManager.getViewportHeight();
        int left = (this.getWidth() - viewportWidth) / 2;
        int top = (this.getHeight() - viewportHeight) / 2;
        int right = this.getWidth() - left;
        int bottom = this.getHeight() - top;
        this.ovalRect.left = left;
        this.ovalRect.top = top;
        this.ovalRect.right = right;
        this.ovalRect.bottom = bottom;
        this.ovalPath.reset();
        this.ovalPath.moveTo((float)left, (float)(this.getHeight() / 2));
        this.ovalPath.arcTo(this.ovalRect, 180.0f, 90.0f, false);
        this.ovalPath.lineTo((float)left, (float)top);
        this.ovalPath.lineTo((float)left, (float)(this.getHeight() / 2));
        this.ovalPath.close();
        canvas.drawPath(this.ovalPath, this.viewportPaint);
        this.ovalPath.reset();
        this.ovalPath.moveTo((float)(this.getWidth() / 2), (float)top);
        this.ovalPath.arcTo(this.ovalRect, 270.0f, 90.0f, false);
        this.ovalPath.lineTo((float)right, (float)top);
        this.ovalPath.lineTo((float)(this.getWidth() / 2), (float)top);
        this.ovalPath.close();
        canvas.drawPath(this.ovalPath, this.viewportPaint);
        this.ovalPath.reset();
        this.ovalPath.moveTo((float)right, (float)(this.getHeight() / 2));
        this.ovalPath.arcTo(this.ovalRect, 0.0f, 90.0f, false);
        this.ovalPath.lineTo((float)right, (float)bottom);
        this.ovalPath.lineTo((float)right, (float)(this.getHeight() / 2));
        this.ovalPath.close();
        canvas.drawPath(this.ovalPath, this.viewportPaint);
        this.ovalPath.reset();
        this.ovalPath.moveTo((float)(this.getWidth() / 2), (float)bottom);
        this.ovalPath.arcTo(this.ovalRect, 90.0f, 90.0f, false);
        this.ovalPath.lineTo((float)left, (float)bottom);
        this.ovalPath.lineTo((float)(this.getWidth() / 2), (float)bottom);
        this.ovalPath.close();
        canvas.drawPath(this.ovalPath, this.viewportPaint);
        this.drawSquareOverlay(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resetTouchManager();
    }

    public void setViewportOverlayColor(@ColorInt int viewportOverlayColor) {
        this.viewportPaint.setColor(viewportOverlayColor);
        this.config.setViewportOverlayColor(viewportOverlayColor);
    }

    public void setViewportOverlayPadding(int viewportOverlayPadding) {
        this.config.setViewportOverlayPadding(viewportOverlayPadding);
        this.resetTouchManager();
        this.invalidate();
    }

    public float getImageRatio() {
        Bitmap bitmap = this.getImageBitmap();
        return bitmap != null ? (float)bitmap.getWidth() / (float)bitmap.getHeight() : 0.0f;
    }

    public float getViewportRatio() {
        return this.touchManager.getAspectRatio();
    }

    public void setViewportRatio(float ratio) {
        if (Float.compare(ratio, 0.0f) == 0) {
            ratio = this.getImageRatio();
        }
        this.touchManager.setAspectRatio(ratio);
        this.resetTouchManager();
        this.invalidate();
    }

    public void setImageResource(@DrawableRes int resId) {
        Bitmap bitmap = resId == 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.setImageBitmap(bitmap);
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
            bitmap = bitmapDrawable.getBitmap();
        } else {
            bitmap = drawable != null ? Utils.asBitmap(drawable, this.getWidth(), this.getHeight()) : null;
        }
        this.setImageBitmap(bitmap);
    }

    public void setImageURI(@Nullable Uri uri) {
        this.extensions().load(uri);
    }

    public void setImageBitmap(@Nullable Bitmap bitmap) {
        this.bitmap = bitmap;
        this.resetTouchManager();
        this.invalidate();
    }

    @Nullable
    public Bitmap getImageBitmap() {
        return this.bitmap;
    }

    private void resetTouchManager() {
        boolean invalidBitmap = this.bitmap == null;
        int bitmapWidth = invalidBitmap ? 0 : this.bitmap.getWidth();
        int bitmapHeight = invalidBitmap ? 0 : this.bitmap.getHeight();
        this.touchManager.resetFor(bitmapWidth, bitmapHeight, this.getWidth(), this.getHeight());
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (!this.isEnabled()) {
            return result;
        }
        this.touchManager.onEvent(event);
        this.invalidate();
        return true;
    }

    @Nullable
    public Bitmap crop() {
        if (this.bitmap == null) {
            return null;
        }
        Bitmap src = this.bitmap;
        Bitmap.Config srcConfig = src.getConfig();
        Bitmap.Config config = srcConfig == null ? Bitmap.Config.ARGB_8888 : srcConfig;
        int viewportHeight = this.touchManager.getViewportHeight();
        int viewportWidth = this.touchManager.getViewportWidth();
        Bitmap dst = Bitmap.createBitmap((int)viewportWidth, (int)viewportHeight, (Bitmap.Config)config);
        Canvas canvas = new Canvas(dst);
        int left = (this.getRight() - viewportWidth) / 2;
        int top = (this.getBottom() - viewportHeight) / 2;
        canvas.translate((float)(-left), (float)(-top));
        this.drawBitmap(canvas);
        return dst;
    }

    public int getViewportWidth() {
        return this.touchManager.getViewportWidth();
    }

    public int getViewportHeight() {
        return this.touchManager.getViewportHeight();
    }

    public Extensions extensions() {
        if (this.extensions == null) {
            this.extensions = new Extensions(this);
        }
        return this.extensions;
    }

    public Matrix getTransformMatrix() {
        return this.transform;
    }

    public static class Extensions {
        private final CropView cropView;

        Extensions(CropView cropView) {
            this.cropView = cropView;
        }

        public void load(@Nullable Object model) {
            new LoadRequest(this.cropView).load(model);
        }

        public LoadRequest using(@Nullable BitmapLoader bitmapLoader) {
            return new LoadRequest(this.cropView).using(bitmapLoader);
        }

        public CropRequest crop() {
            return new CropRequest(this.cropView);
        }

        public void pickUsing(@NonNull Activity activity, int requestCode) {
            CropViewExtensions.pickUsing(activity, requestCode);
        }

        public void pickUsing(@NonNull Fragment fragment, int requestCode) {
            CropViewExtensions.pickUsing(fragment, requestCode);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Shape {
        public static final int RECTANGLE = 0;
        public static final int OVAL = 1;
    }
}

