/*
 * Decompiled with CFR 0.152.
 */
package com.eyeem.recyclerviewtools;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.eyeem.recyclerviewtools.R;

public class SmarterSwipeRefreshLayout
extends SwipeRefreshLayout
implements AppBarLayout.OnOffsetChangedListener {
    private int appbarLayoutResId = -1;
    private int targetResId = -1;
    private View target = null;
    private AppBarLayout appBarLayout;
    private boolean appBarExpanded = true;

    public SmarterSwipeRefreshLayout(Context context) {
        super(context);
    }

    public SmarterSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SmarterSwipeRefreshLayout);
        this.targetResId = a.getResourceId(R.styleable.SmarterSwipeRefreshLayout_target, -1);
        this.appbarLayoutResId = a.getResourceId(R.styleable.SmarterSwipeRefreshLayout_appBarLayout, -1);
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.targetResId > 0 && this.target == null) {
            this.target = this.findViewById(this.targetResId);
        }
        if (this.appbarLayoutResId > 0 && this.appBarLayout == null) {
            this.appBarLayout = (AppBarLayout)this.findViewById(this.appbarLayoutResId);
            if (this.appBarLayout == null) {
                ViewParent _parent = null;
                for (ViewParent parent = this.getParent(); !(parent == null || (_parent = parent) instanceof View && ((View)_parent).getId() == 0x1020002); parent = parent.getParent()) {
                }
                if (_parent instanceof View) {
                    this.appBarLayout = (AppBarLayout)((View)_parent).findViewById(this.appbarLayoutResId);
                }
            }
        }
        if (this.appBarLayout != null) {
            this.appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        }
        try {
            AppBarLayout.Behavior b = (AppBarLayout.Behavior)((CoordinatorLayout.LayoutParams)this.appBarLayout.getLayoutParams()).getBehavior();
            int currentOffset = b.getTopAndBottomOffset();
            this.onOffsetChanged(this.appBarLayout, currentOffset);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.appBarLayout != null) {
            this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        }
    }

    public void setTarget(View target, @Nullable AppBarLayout appBarLayout) {
        this.target = target;
        this.appBarLayout = appBarLayout;
    }

    public boolean canChildScrollUp() {
        if (this.target != null) {
            return !this.appBarExpanded || ViewCompat.canScrollVertically((View)this.target, (int)-1);
        }
        return super.canChildScrollUp();
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int i) {
        this.appBarExpanded = i >= 0;
    }
}

