/*
 * Decompiled with CFR 0.152.
 */
package com.eyeem.recyclerviewtools;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.lang.ref.WeakReference;

class FastScrollToTop {
    private static final int POSITION_THRESHOLD = 15;
    private static final int LAST_SCROLL = 5;
    private static final long SCROLL_TO_POSITION_DELAY = 222L;
    private final WeakReference<RecyclerView> weakRecycler;
    private final int lastScroll;
    private Runnable runAfterSpeedUp = new Runnable(){

        @Override
        public void run() {
            RecyclerView recyclerView = (RecyclerView)FastScrollToTop.this.weakRecycler.get();
            if (recyclerView == null) {
                return;
            }
            recyclerView.scrollToPosition(FastScrollToTop.this.lastScroll);
            recyclerView.smoothScrollToPosition(0);
        }
    };

    public FastScrollToTop(RecyclerView recyclerView) {
        this(recyclerView, 15, 5, 222L);
    }

    public FastScrollToTop(RecyclerView recyclerView, int threshold, int lastScroll, long scrollToPositionDelay) {
        this.lastScroll = lastScroll;
        if (recyclerView.getChildCount() == 0) {
            this.weakRecycler = null;
            return;
        }
        View v = recyclerView.getChildAt(0);
        int position = recyclerView.getChildAdapterPosition(v);
        if (position < threshold) {
            recyclerView.smoothScrollToPosition(0);
            this.weakRecycler = null;
            return;
        }
        this.weakRecycler = new WeakReference<RecyclerView>(recyclerView);
        recyclerView.smoothScrollToPosition(0);
        recyclerView.postDelayed(this.runAfterSpeedUp, scrollToPositionDelay);
    }
}

