/*
 * Decompiled with CFR 0.152.
 */
package com.eyeem.recyclerviewtools;

import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.eyeem.recyclerviewtools.adapter.WrapAdapter;

public class LoadMoreOnScrollListener
extends RecyclerView.OnScrollListener {
    private static final int DEFAULT_POSITION_OFFSET = 3;
    private final int positionOffset;
    private final Listener listener;
    private boolean loadMoreListenerCalled = false;

    public LoadMoreOnScrollListener(Listener listener) {
        this(listener, 3);
    }

    public LoadMoreOnScrollListener(Listener listener, int positionOffset) {
        this.listener = listener;
        this.positionOffset = positionOffset;
    }

    public void setLoadMoreListenerCalled(boolean value) {
        this.loadMoreListenerCalled = value;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (!ViewCompat.canScrollVertically((View)recyclerView, (int)-1)) {
            this.loadMoreListenerCalled = false;
        }
        try {
            RecyclerView.Adapter a = recyclerView.getAdapter();
            if (a instanceof WrapAdapter && ((WrapAdapter)a).getWrappedCount() == 0) {
                return;
            }
            if (a.getItemCount() == 0) {
                return;
            }
            int position = recyclerView.getChildAdapterPosition(recyclerView.getChildAt(recyclerView.getChildCount() - 1));
            if (position == -1) {
                return;
            }
            if (position >= recyclerView.getAdapter().getItemCount() - this.positionOffset) {
                if (!this.loadMoreListenerCalled) {
                    this.listener.onLoadMore(recyclerView);
                    this.loadMoreListenerCalled = true;
                }
            } else {
                this.loadMoreListenerCalled = false;
            }
        }
        catch (NullPointerException e) {
            this.loadMoreListenerCalled = false;
        }
    }

    public static interface Listener {
        public void onLoadMore(RecyclerView var1);
    }
}

