/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader.columnfilters;

import com.exponam.core.internalColumnSegmentFilters.ComparisonFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.StringFilterDefinition;
import com.exponam.core.reader.columnfilters.AndFilterNode;
import com.exponam.core.reader.columnfilters.ComparisonFilterNode;
import com.exponam.core.reader.columnfilters.ConvertibleFilterNode;
import com.exponam.core.reader.columnfilters.FilterNode;
import com.exponam.core.reader.columnfilters.NullityFilterNode;
import com.exponam.core.reader.columnfilters.OrFilterNode;
import com.exponam.core.reader.columnfilters.StringFilterNode;
import java.util.Optional;

public class Builder {
    private FilterNode root = null;

    private Builder() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder withRootFilter(FilterNode root) {
        this.root = root;
        return this;
    }

    public Optional<FilterDefinition<?, ?>> build() {
        if (this.root == null) {
            return Optional.empty();
        }
        if (!(this.root instanceof ConvertibleFilterNode)) {
            throw new IllegalArgumentException("Improper root node");
        }
        ConvertibleFilterNode convertibleRoot = (ConvertibleFilterNode)this.root;
        return Optional.of(convertibleRoot.underlying());
    }

    public static FilterNode filter(ComparisonFilterDefinition.Kind comparisonKind, Object value) {
        return new ComparisonFilterNode(comparisonKind, value);
    }

    public static FilterNode stringFilter(StringFilterDefinition.Kind comparisonKind, String value, boolean caseSensitive) {
        return new StringFilterNode(comparisonKind, value, caseSensitive);
    }

    public static FilterNode isNull() {
        return new NullityFilterNode(true);
    }

    public static FilterNode isNotNull() {
        return new NullityFilterNode(true);
    }

    public static FilterNode or(FilterNode ... nodes) {
        return new OrFilterNode(nodes);
    }

    public static FilterNode and(FilterNode ... nodes) {
        return new AndFilterNode(nodes);
    }
}

