/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader;

import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.Operations;
import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.datetimes.ExponamDateTime;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.times.ExponamTime;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.reader.BigReader;
import com.exponam.core.reader.QueryColumnAttributes;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Marshaller {
    private final BigReader bigReader;

    public Marshaller(BigReader bigReader) {
        this.bigReader = Objects.requireNonNull(bigReader, "bigReader");
    }

    public <T> T getColumnValueAs(int worksheetIndex, int rowIndex, int columnIndex, Type desiredType) {
        if (String.class.equals((Object)desiredType)) {
            return (T)this.bigReader.getValueAsString(worksheetIndex, rowIndex, columnIndex);
        }
        ColumnTypes columnType = this.bigReader.getWorksheet(worksheetIndex).getColumns().get(columnIndex).getType();
        if (desiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)desiredType;
            Type rawType = ((ParameterizedType)desiredType).getRawType();
            if (!rawType.equals(Optional.class)) {
                throw new IllegalArgumentException(String.format("Only Optional<T> permitted as a parameterized type, instead found '%s'", desiredType));
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            int len = typeArguments.length;
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Unable to convert to an unqualified type '%s'", desiredType));
            }
            if (len > 1) {
                throw new IllegalArgumentException(String.format("Unable to convert to type '%s'", desiredType));
            }
            Type targetType = typeArguments[0];
            return (T)Optional.ofNullable(this.getForTargetType(worksheetIndex, rowIndex, columnIndex, targetType, columnType));
        }
        if (desiredType.equals(Optional.class)) {
            throw new IllegalArgumentException(String.format("Expected a qualified Optional<T> instead of '%s'", desiredType));
        }
        return this.getForTargetType(worksheetIndex, rowIndex, columnIndex, desiredType, columnType);
    }

    public void fetchRows(int worksheetIndex, int startRow, int endRow, Map<Integer, QueryColumnAttributes> queryColumns, BiConsumer<Integer, Function<Integer, Object>> rowConsumer) {
        int startSegment = startRow / 32768;
        int endSegment = endRow / 32768;
        Integer[] sortedQueryColumnIndexes = (Integer[])queryColumns.keySet().stream().sorted().toArray(Integer[]::new);
        List filteredColumns = queryColumns.entrySet().stream().filter(entry -> ((QueryColumnAttributes)entry.getValue()).getColumnFilter().isPresent()).map(Map.Entry::getKey).collect(Collectors.toList());
        HashMap valuesForColumns = new HashMap(sortedQueryColumnIndexes.length);
        for (Integer columnIndex2 : sortedQueryColumnIndexes) {
            ArrayList<Object> valuesForColumn = new ArrayList<Object>(32768);
            for (int row = 0; row < 32768; ++row) {
                valuesForColumn.add(null);
            }
            valuesForColumns.put(columnIndex2, valuesForColumn);
        }
        HashMap<Integer, Function<Object, Object>> columnValueTransformers = new HashMap<Integer, Function<Object, Object>>(sortedQueryColumnIndexes.length);
        Integer[] integerArray = sortedQueryColumnIndexes;
        int n = integerArray.length;
        for (int columnIndex2 = 0; columnIndex2 < n; ++columnIndex2) {
            int columnIndex3 = integerArray[columnIndex2];
            Type desiredType = queryColumns.get(columnIndex3).getDesiredType();
            columnValueTransformers.put(columnIndex3, desiredType.equals(String.class) ? null : this.getTransformerForColumn(this.bigReader.getWorksheet(worksheetIndex).getColumns().get(columnIndex3).getType(), desiredType));
        }
        for (int segmentIndex = startSegment; segmentIndex <= endSegment; ++segmentIndex) {
            IBitArray hitsAfterApplyingColumnFilters;
            int endRowInSegment;
            int startRowInSegment = segmentIndex == startSegment ? startRow % 32768 : 0;
            int n2 = endRowInSegment = segmentIndex == endSegment ? endRow % 32768 : Short.MAX_VALUE;
            if (filteredColumns.isEmpty()) {
                hitsAfterApplyingColumnFilters = new AllTrueBitArray(32768);
            } else {
                Map<Integer, IBitArray> hitsByColumn = filteredColumns.stream().collect(Collectors.toMap(columnIndex -> columnIndex, columnIndex -> new BitArray(32768)));
                int localSegmentIndex = segmentIndex;
                filteredColumns.parallelStream().forEach(columnIndex -> {
                    List valuesForColumn = (List)valuesForColumns.get(columnIndex);
                    IBitArray hitsForThisColumn = (IBitArray)hitsByColumn.get(columnIndex);
                    QueryColumnAttributes queryColumnAttributes = (QueryColumnAttributes)queryColumns.get(columnIndex);
                    Function transformer = (Function)columnValueTransformers.get(columnIndex);
                    if (transformer == null) {
                        this.bigReader.getValuesAsStrings(worksheetIndex, localSegmentIndex, (int)columnIndex, queryColumnAttributes.getColumnFilter(), startRowInSegment, endRowInSegment, (rowInSegment, stringValue) -> {
                            if (queryColumnAttributes.getProject()) {
                                valuesForColumn.set((int)rowInSegment, stringValue);
                            }
                            hitsForThisColumn.set((int)rowInSegment, true);
                        });
                    } else {
                        this.bigReader.getValues(worksheetIndex, localSegmentIndex, (int)columnIndex, queryColumnAttributes.getColumnFilter(), startRowInSegment, endRowInSegment, (rowInSegment, value) -> {
                            if (queryColumnAttributes.getProject()) {
                                valuesForColumn.set((int)rowInSegment, transformer.apply(value));
                            }
                            hitsForThisColumn.set((int)rowInSegment, true);
                        });
                    }
                });
                hitsAfterApplyingColumnFilters = Operations.and(hitsByColumn.values().toArray(new IBitArray[0])).toReadOnly();
            }
            if (hitsAfterApplyingColumnFilters.numPasses() > 0) {
                int localSegmentIndex = segmentIndex;
                IntStream.range(0, sortedQueryColumnIndexes.length).parallel().forEach(col -> {
                    int columnIndex = sortedQueryColumnIndexes[col];
                    if (filteredColumns.contains(columnIndex)) {
                        return;
                    }
                    QueryColumnAttributes queryColumnAttributes = (QueryColumnAttributes)queryColumns.get(columnIndex);
                    if (!queryColumnAttributes.getProject()) {
                        return;
                    }
                    List valuesForColumn = (List)valuesForColumns.get(columnIndex);
                    Function transformer = (Function)columnValueTransformers.get(columnIndex);
                    if (transformer == null) {
                        this.bigReader.getValuesAsStrings(worksheetIndex, localSegmentIndex, columnIndex, queryColumnAttributes.getColumnFilter(), startRowInSegment, endRowInSegment, (rowInSegment, stringValue) -> valuesForColumn.set((int)rowInSegment, stringValue));
                    } else {
                        this.bigReader.getValues(worksheetIndex, localSegmentIndex, columnIndex, queryColumnAttributes.getColumnFilter(), startRowInSegment, endRowInSegment, (rowInSegment, value) -> valuesForColumn.set((int)rowInSegment, transformer.apply(value)));
                    }
                });
                for (int i = startRowInSegment; i <= endRowInSegment; ++i) {
                    if (!hitsAfterApplyingColumnFilters.get(i)) continue;
                    int rowNumber = i + segmentIndex * 32768;
                    int finalI = i;
                    rowConsumer.accept(rowNumber, columnIndex -> ((List)valuesForColumns.get(columnIndex)).get(finalI));
                }
            }
            System.gc();
        }
    }

    private <T> T getForTargetType(int worksheetIndex, int rowIndex, int columnIndex, Type desiredType, ColumnTypes columnType) {
        if (desiredType.equals(String.class)) {
            return (T)this.bigReader.getValueAsString(worksheetIndex, rowIndex, columnIndex);
        }
        Object o = this.bigReader.getValue(worksheetIndex, rowIndex, columnIndex);
        if (o == null) {
            return null;
        }
        switch (columnType) {
            case Double: {
                if (!InternalDoubleColumnSegmentUtilities.Empty.equals(o)) break;
                return null;
            }
            case Long: {
                if (!InternalLongColumnSegmentUtilities.Empty.equals(o)) break;
                return null;
            }
            case Date: {
                if (!InternalDateColumnSegmentUtilities.EmptyDate.equals(o)) break;
                return null;
            }
            case DateTime: {
                if (!InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o)) break;
                return null;
            }
            case Boolean: {
                break;
            }
            case Time: {
                if (!InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o)) break;
                return null;
            }
        }
        if (o.getClass().equals(desiredType)) {
            return (T)o;
        }
        if (o instanceof Optional) {
            Optional optionalO = (Optional)o;
            if (optionalO.isPresent()) {
                o = optionalO.get();
            } else {
                return null;
            }
        }
        if (o instanceof Double) {
            Double doubleO = (Double)o;
            if (desiredType.equals(Long.class)) {
                return (T)Long.valueOf(doubleO.longValue());
            }
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(doubleO.intValue());
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf(doubleO.shortValue());
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf(doubleO.byteValue());
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(doubleO.floatValue());
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(doubleO);
            }
        }
        if (o instanceof Long) {
            Long longO = (Long)o;
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(longO.intValue());
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf(longO.shortValue());
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf(longO.byteValue());
            }
            if (desiredType.equals(Double.class)) {
                return (T)Double.valueOf(longO.doubleValue());
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(longO.floatValue());
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(longO);
            }
        }
        if (o instanceof Boolean) {
            int booleanIntValue;
            boolean booleanO = (Boolean)o;
            int n = booleanIntValue = booleanO ? 1 : 0;
            if (desiredType.equals(Long.class)) {
                return (T)Long.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf((short)booleanIntValue);
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf((byte)booleanIntValue);
            }
            if (desiredType.equals(Double.class)) {
                return (T)Double.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(booleanIntValue);
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(booleanIntValue);
            }
        }
        if (o instanceof ExponamTime) {
            switch (columnType) {
                case Time: {
                    ExponamTime timeO = (ExponamTime)o;
                    if (desiredType.equals(Time.class)) {
                        return (T)timeO.toSqlTime();
                    }
                    if (desiredType.equals(java.util.Date.class)) {
                        return (T)timeO.toSqlTime();
                    }
                    if (desiredType.equals(Long.class)) {
                        return (T)Long.valueOf(timeO.getTimeOfDayInMillis());
                    }
                    if (!desiredType.equals(BigDecimal.class)) break;
                    return (T)BigDecimal.valueOf(timeO.getTimeOfDayInMillis());
                }
            }
        }
        if (o instanceof ExponamDateTime) {
            switch (columnType) {
                case DateTime: {
                    ExponamDateTime dateO = (ExponamDateTime)o;
                    if (desiredType.equals(Timestamp.class)) {
                        return (T)dateO.toSqlTimestamp();
                    }
                    if (desiredType.equals(Date.class)) {
                        return (T)new Date(dateO.toSqlTimestamp().getTime());
                    }
                    if (desiredType.equals(java.util.Date.class)) {
                        return (T)dateO.toSqlTimestamp();
                    }
                    if (desiredType.equals(Long.class)) {
                        return (T)Long.valueOf(dateO.getDateTimeInMillisInvariantWithTimezone());
                    }
                    if (!desiredType.equals(BigDecimal.class)) break;
                    return (T)BigDecimal.valueOf(dateO.getDateTimeInMillisInvariantWithTimezone());
                }
            }
        }
        if (o instanceof java.util.Date) {
            switch (columnType) {
                case Date: 
                case DateTime: 
                case Time: {
                    java.util.Date dateO = (java.util.Date)o;
                    if (desiredType.equals(Date.class)) {
                        return (T)new Date(dateO.getTime());
                    }
                    if (desiredType.equals(java.util.Date.class)) {
                        return (T)new java.util.Date(dateO.getTime());
                    }
                    if (desiredType.equals(Long.class)) {
                        return (T)Long.valueOf(dateO.getTime());
                    }
                    if (!desiredType.equals(BigDecimal.class)) break;
                    return (T)BigDecimal.valueOf(dateO.getTime());
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert object of type '%s' to desired type '%s' for worksheet '%d', row '%d', and column '%d',", o.getClass().getName(), desiredType, worksheetIndex, rowIndex, columnIndex));
    }

    private Function<Object, Object> getTransformerForColumn(ColumnTypes columnType, Type desiredType) {
        if (desiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)desiredType;
            Type rawType = ((ParameterizedType)desiredType).getRawType();
            if (!rawType.equals(Optional.class)) {
                throw new IllegalArgumentException(String.format("Only Optional<T> permitted as a parameterized type, instead found '%s'", desiredType));
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            int len = typeArguments.length;
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Unable to convert to an unqualified type '%s'", desiredType));
            }
            if (len > 1) {
                throw new IllegalArgumentException(String.format("Unable to convert to type '%s'", desiredType));
            }
            Type targetType = typeArguments[0];
            return o -> Optional.ofNullable(this.getTransformerForTargetType(targetType, columnType).apply(o));
        }
        if (desiredType.equals(Optional.class)) {
            throw new IllegalArgumentException(String.format("Expected a qualified Optional<T> instead of '%s'", desiredType));
        }
        return this.getTransformerForTargetType(desiredType, columnType);
    }

    private Function<Object, Object> getTransformerForTargetType(Type desiredType, ColumnTypes columnType) {
        switch (columnType) {
            case Boolean: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(Long.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Long.valueOf(1L) : Long.valueOf(0L));
                }
                if (desiredType.equals(Integer.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Integer.valueOf(1) : Integer.valueOf(0));
                }
                if (desiredType.equals(Short.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Short.valueOf((short)1) : Short.valueOf((short)0));
                }
                if (desiredType.equals(Byte.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0));
                }
                if (desiredType.equals(Double.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Double.valueOf(1.0) : Double.valueOf(0.0));
                }
                if (desiredType.equals(Float.class)) {
                    return o -> o == null ? null : ((Boolean)o != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f));
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> o == null ? null : ((Boolean)o != false ? BigDecimal.ONE : BigDecimal.ZERO);
            }
            case Date: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(Date.class)) {
                    return o -> {
                        Marshaller.required(o, java.util.Date.class);
                        return o == null || InternalDateColumnSegmentUtilities.EmptyDate.equals(o) ? null : new Date(((java.util.Date)o).getTime());
                    };
                }
                if (desiredType.equals(java.util.Date.class)) {
                    return o -> {
                        Marshaller.required(o, java.util.Date.class);
                        return o == null || InternalDateColumnSegmentUtilities.EmptyDate.equals(o) ? null : (java.util.Date)o;
                    };
                }
                if (desiredType.equals(Long.class)) {
                    return o -> {
                        Marshaller.required(o, java.util.Date.class);
                        return o == null || InternalDateColumnSegmentUtilities.EmptyDate.equals(o) ? null : Long.valueOf(((java.util.Date)o).getTime());
                    };
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> {
                    Marshaller.required(o, java.util.Date.class);
                    return o == null || InternalDateColumnSegmentUtilities.EmptyDate.equals(o) ? null : BigDecimal.valueOf(((java.util.Date)o).getTime());
                };
            }
            case DateTime: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(java.util.Date.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamDateTime.class);
                        return o == null || InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o) ? null : ((ExponamDateTime)o).toSqlTimestamp();
                    };
                }
                if (desiredType.equals(Timestamp.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamDateTime.class);
                        return o == null || InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o) ? null : ((ExponamDateTime)o).toSqlTimestamp();
                    };
                }
                if (desiredType.equals(Long.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamDateTime.class);
                        return o == null || InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o) ? null : Long.valueOf(((ExponamDateTime)o).getDateTimeInMillisInvariantWithTimezone());
                    };
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> {
                    Marshaller.required(o, ExponamDateTime.class);
                    return o == null || InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o) ? null : BigDecimal.valueOf(((ExponamDateTime)o).getDateTimeInMillisInvariantWithTimezone());
                };
            }
            case Double: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(Double.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : (Double)o;
                    };
                }
                if (desiredType.equals(Long.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : Long.valueOf(((Double)o).longValue());
                    };
                }
                if (desiredType.equals(Integer.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : Integer.valueOf(((Double)o).intValue());
                    };
                }
                if (desiredType.equals(Short.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : Short.valueOf(((Double)o).shortValue());
                    };
                }
                if (desiredType.equals(Byte.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : Byte.valueOf(((Double)o).byteValue());
                    };
                }
                if (desiredType.equals(Float.class)) {
                    return o -> {
                        Marshaller.required(o, Double.class);
                        return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : Float.valueOf(((Double)o).floatValue());
                    };
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> {
                    Marshaller.required(o, Double.class);
                    return o == null || InternalDoubleColumnSegmentUtilities.Empty.equals(o) ? null : BigDecimal.valueOf((Double)o);
                };
            }
            case Long: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(Long.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : (Long)o;
                    };
                }
                if (desiredType.equals(Integer.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : Integer.valueOf(((Long)o).intValue());
                    };
                }
                if (desiredType.equals(Short.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : Short.valueOf(((Long)o).shortValue());
                    };
                }
                if (desiredType.equals(Byte.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : Byte.valueOf(((Long)o).byteValue());
                    };
                }
                if (desiredType.equals(Double.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : Double.valueOf(((Long)o).doubleValue());
                    };
                }
                if (desiredType.equals(Float.class)) {
                    return o -> {
                        Marshaller.required(o, Long.class);
                        return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : Float.valueOf(((Long)o).floatValue());
                    };
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> {
                    Marshaller.required(o, Long.class);
                    return o == null || InternalLongColumnSegmentUtilities.Empty.equals(o) ? null : BigDecimal.valueOf((Long)o);
                };
            }
            case String: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (!desiredType.equals(String.class)) break;
                return o -> {
                    Marshaller.required(o, String.class);
                    return (String)o;
                };
            }
            case Time: {
                if (desiredType.equals(Object.class)) {
                    return o -> o;
                }
                if (desiredType.equals(Time.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamTime.class);
                        return o == null || InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o) ? null : ((ExponamTime)o).toSqlTime();
                    };
                }
                if (desiredType.equals(java.util.Date.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamTime.class);
                        return o == null || InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o) ? null : ((ExponamTime)o).toSqlTime();
                    };
                }
                if (desiredType.equals(Long.class)) {
                    return o -> {
                        Marshaller.required(o, ExponamTime.class);
                        return o == null || InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o) ? null : Long.valueOf(((ExponamTime)o).getTimeOfDayInMillis());
                    };
                }
                if (!desiredType.equals(BigDecimal.class)) break;
                return o -> {
                    Marshaller.required(o, ExponamTime.class);
                    return o == null || InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o) ? null : BigDecimal.valueOf(((ExponamTime)o).getTimeOfDayInMillis());
                };
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert column type '%s' to desired type '%s'", columnType.name(), desiredType));
    }

    private static void required(Object o, Class<?> c) {
        if (o != null && !c.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException(String.format("Required %s but got object %s with value %s", c.getCanonicalName(), o.getClass().getCanonicalName(), o.toString()));
        }
    }
}

