/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.times;

import com.exponam.core.internalColumnSegments.times.ExponamTime;
import com.exponam.core.internalColumns.InternalColumn;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class InternalTimeColumnSegmentUtilities {
    public static final ExponamTime EMPTY_TIME = new ExponamTime(-1);
    public static final Integer Empty = Integer.MIN_VALUE;
    public static final ExponamTime EPOCH = new ExponamTime(0);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    public static Function<ExponamTime, Integer> toAtRest = InternalTimeColumnSegmentUtilities::sinceBasis;
    public static Function<Integer, ExponamTime> toInMemory = InternalTimeColumnSegmentUtilities::fromBasis;
    public static BiFunction<Integer, InternalColumn, String> atRestToString = (value, column) -> {
        if (value.equals(Empty)) {
            return "";
        }
        ExponamTime exponamTime = InternalTimeColumnSegmentUtilities.fromBasis(value);
        Time sqlTime = exponamTime.toSqlTime();
        if (StringUtils.isEmpty((CharSequence)column.getJavaCompatibleDisplayMask())) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.format(sqlTime);
            }
        }
        SimpleDateFormat displaySdf = new SimpleDateFormat(column.getJavaCompatibleDisplayMask());
        return displaySdf.format(sqlTime);
    };

    private static Integer sinceBasis(ExponamTime dt) {
        if (dt.equals(EMPTY_TIME)) {
            return Empty;
        }
        return dt.getTimeOfDayInMillis();
    }

    private static ExponamTime fromBasis(Integer dt) {
        return new ExponamTime(dt);
    }

    public static Time fromLocalTime(LocalTime localTime) {
        long epochMillis = localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli();
        return new Time(epochMillis);
    }
}

