/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.doubles;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.DoubleWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;

public class InternalDoubleWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<Double, Double> {
    private Double[] sortedValues;
    private long[] packedIndex;
    private int numValues;
    private InternalColumnSegmentIndex index;

    InternalDoubleWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<Double, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(d -> d, (TAtRest d) -> d, (TAtRest atRestValue) -> atRestValue.equals(InternalDoubleColumnSegmentUtilities.Empty));
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new Double[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalDoubleWithLocalDictionaryColumnSegment(DoubleWithLocalDictionaryColumnSegment protoSegment) {
        super(d -> d, (TAtRest d) -> d, (TAtRest atRestValue) -> atRestValue.equals(InternalDoubleColumnSegmentUtilities.Empty));
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = protoSegment.getDoublesList().toArray(new Double[0]);
        this.packedIndex = InternalDoubleWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    public Double[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(Double value) {
        return value.equals(InternalDoubleColumnSegmentUtilities.Empty);
    }

    @Override
    public String valueToString(Double value) {
        return InternalDoubleColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Double marshall(Object o) {
        return (Double)ConvertForColumnType.convert(o, ColumnTypes.Double);
    }

    @Override
    public ColumnSegmentBase toProto() {
        DoubleWithLocalDictionaryColumnSegment.Builder builder = DoubleWithLocalDictionaryColumnSegment.newBuilder().addAllDoubles(() -> Iterators.forArray(this.sortedValues)).addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        DoubleWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeDoubleWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

