/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.datetimes.ExponamDateTime;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.DateTimeWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class InternalDateTimeWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<ExponamDateTime, Long> {
    private final int numValues;
    private Long minValue;
    private Long maxValue;
    private boolean emptyExists;
    private Long[] rowOrderValues;

    InternalDateTimeWithRowOrderDataColumnSegment(int numRowsInSegment, Map<ExponamDateTime, List<Integer>> valuesAndRows) {
        super(InternalDateTimeColumnSegmentUtilities.toAtRest, InternalDateTimeColumnSegmentUtilities.toInMemory);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, Long.class);
    }

    InternalDateTimeWithRowOrderDataColumnSegment(DateTimeWithRowOrderDataColumnSegment protoSegment) {
        super(InternalDateTimeColumnSegmentUtilities.toAtRest, InternalDateTimeColumnSegmentUtilities.toInMemory);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinDateTimeValue();
        this.maxValue = protoSegment.getMaxDateTimeValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = protoSegment.getRowOrderDateTimeValuesList().toArray(new Long[0]);
    }

    protected Long[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(Long value) {
        return value.equals(InternalDateTimeColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Long value) {
        return InternalDateTimeColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Optional<ExponamDateTime> getMinValue() {
        return Optional.of(InternalDateTimeColumnSegmentUtilities.toInMemory.apply(this.minValue));
    }

    @Override
    public Optional<ExponamDateTime> getMaxValue() {
        return Optional.of(InternalDateTimeColumnSegmentUtilities.toInMemory.apply(this.maxValue));
    }

    @Override
    public boolean getEmptyExists() {
        return this.emptyExists;
    }

    @Override
    public ExponamDateTime marshall(Object o) {
        return (ExponamDateTime)ConvertForColumnType.convert(o, ColumnTypes.DateTime);
    }

    @Override
    public ColumnSegmentBase toProto() {
        DateTimeWithRowOrderDataColumnSegment protoSegment = DateTimeWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinDateTimeValue(this.minValue).setMaxDateTimeValue(this.maxValue).setEmptyExists(this.emptyExists).addAllRowOrderDateTimeValues(() -> Iterators.forArray(this.rowOrderValues)).build();
        return ColumnSegmentBase.newBuilder().mergeDateTimeWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

