/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithOneValue;
import com.exponam.core.internalColumnSegments.datetimes.ExponamDateTime;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.DateTimeWithOneValueColumnSegment;

public class InternalDateTimeWithOneValueColumnSegment
extends ColumnSegmentWithOneValue<ExponamDateTime, Long> {
    private final Long singleValue;
    private final int numValues;

    InternalDateTimeWithOneValueColumnSegment(ExponamDateTime singleValue, int numValues) {
        this.singleValue = InternalDateTimeColumnSegmentUtilities.toAtRest.apply(singleValue);
        this.numValues = numValues;
    }

    InternalDateTimeWithOneValueColumnSegment(DateTimeWithOneValueColumnSegment protoSegment) {
        this.singleValue = protoSegment.getSingleValue();
        this.numValues = protoSegment.getNumValues();
    }

    @Override
    protected Long singleValueAtRest() {
        return this.singleValue;
    }

    @Override
    protected ExponamDateTime singleValue() {
        return InternalDateTimeColumnSegmentUtilities.toInMemory.apply(this.singleValue);
    }

    @Override
    public boolean isSingleValueEmpty() {
        return this.singleValue.equals(InternalDateTimeColumnSegmentUtilities.Empty);
    }

    @Override
    protected String singleValueToString() {
        return InternalDateTimeColumnSegmentUtilities.atRestToString.apply(this.singleValue, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ExponamDateTime marshall(Object o) {
        return (ExponamDateTime)ConvertForColumnType.convert(o, ColumnTypes.DateTime);
    }

    @Override
    public ColumnSegmentBase toProto() {
        DateTimeWithOneValueColumnSegment protoSegment = DateTimeWithOneValueColumnSegment.newBuilder().setSingleValue(this.singleValue).setNumValues(this.numValues).build();
        return ColumnSegmentBase.newBuilder().mergeDateTimeWithOneValueColumnSegment(protoSegment).build();
    }
}

