/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import java.util.stream.LongStream;

public class IndexedValuesBitFieldPacker {
    private static final long[] getValueMasks = LongStream.range(0L, 17L).map(i -> IndexedValuesBitFieldPacker.generateMask((int)i)).toArray();
    private final int bitsPerEntry;
    private final int entriesPerLong;
    private final int greatestZeroBasedEntry;
    private final long[] packedEntries;

    public IndexedValuesBitFieldPacker(long[] packedEntries, int greatestZeroBasedEntry) {
        this.packedEntries = packedEntries;
        this.greatestZeroBasedEntry = greatestZeroBasedEntry;
        this.bitsPerEntry = IndexedValuesBitFieldPacker.calculateBitsPerEntry(greatestZeroBasedEntry);
        this.entriesPerLong = IndexedValuesBitFieldPacker.calculateEntriesPerLong(this.bitsPerEntry);
    }

    public int getValueForEntry(int entry) {
        int index = this.indexForLongContainingEntry(entry);
        int bitRegionInLong = this.bitRegionInLongContainingEntry(entry);
        long longElement = this.packedEntries[index];
        longElement >>= bitRegionInLong * this.bitsPerEntry;
        long mask = getValueMasks[this.bitsPerEntry];
        return (int)(longElement &= mask);
    }

    public void putValueForEntry(int entry, int value) {
        if (entry < 0 || entry > Short.MAX_VALUE) {
            throw new IllegalArgumentException("entry out of range");
        }
        if (value < 0 || value > this.greatestZeroBasedEntry) {
            throw new IllegalArgumentException("value out of range");
        }
        int index = this.indexForLongContainingEntry(entry);
        int bitRegionInLong = this.bitRegionInLongContainingEntry(entry);
        long longElement = this.packedEntries[index];
        if (this.getValueForEntry(entry) != 0) {
            throw new IllegalArgumentException("expected value for entry to still be zero");
        }
        if (value == 0) {
            return;
        }
        long longValue = value;
        this.packedEntries[index] = longElement |= (longValue <<= bitRegionInLong * this.bitsPerEntry);
    }

    private int bitRegionInLongContainingEntry(int entry) {
        return entry % this.entriesPerLong;
    }

    private int indexForLongContainingEntry(int entry) {
        return entry / this.entriesPerLong;
    }

    public static long[] packedEntries(int greatestZeroBasedEntry, int numValues) {
        if (greatestZeroBasedEntry <= 0) {
            throw new IllegalArgumentException("Expected a value > 0");
        }
        if (!IndexedValuesBitFieldPacker.canUsePackedEntries(greatestZeroBasedEntry)) {
            throw new IllegalArgumentException("Cannot use packedEntries");
        }
        return new long[IndexedValuesBitFieldPacker.calculateNumLongsToHoldEntriesForValues(greatestZeroBasedEntry, numValues)];
    }

    static boolean canUsePackedEntries(int greatestZeroBasedEntry) {
        if (greatestZeroBasedEntry <= 0) {
            throw new IllegalArgumentException("Expected a value > 0");
        }
        return IndexedValuesBitFieldPacker.calculateBitsPerEntry(greatestZeroBasedEntry) <= 16;
    }

    private static long generateMask(int bitsPerEntry) {
        return (long)Math.pow(2.0, bitsPerEntry) - 1L;
    }

    private static int calculateEntriesPerLong(int bitsPerEntry) {
        return 64 / bitsPerEntry;
    }

    private static int calculateNumLongsToHoldEntriesForValues(int greatestZeroBasedEntry, int numValues) {
        int bitsPerEntry = IndexedValuesBitFieldPacker.calculateBitsPerEntry(greatestZeroBasedEntry);
        int entriesPerLong = IndexedValuesBitFieldPacker.calculateEntriesPerLong(bitsPerEntry);
        int requiredLongs = numValues / entriesPerLong;
        if (numValues % entriesPerLong > 0) {
            ++requiredLongs;
        }
        return requiredLongs;
    }

    static int calculateBitsPerEntry(int greatestZeroBasedEntry) {
        if (greatestZeroBasedEntry <= 0) {
            throw new IllegalArgumentException("Expected a value > 0");
        }
        int bits = 1;
        for (int entriesForBits = 2; greatestZeroBasedEntry >= entriesForBits && bits < 16; ++bits, entriesForBits *= 2) {
        }
        return bits;
    }
}

