/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.UnreachableCodeException;
import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.ApplyComparisonFilterToRowOrderDataColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyNullityFilterToRowOrderDataColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyStringFilterToRowOrderDataColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilter;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegmentFilters.NullityFilter;
import com.exponam.core.internalColumnSegmentFilters.NullityFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.StringFilter;
import com.exponam.core.internalColumnSegmentFilters.StringFilterDefinition;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;

public abstract class ColumnSegmentWithRowOrderValues<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
extends InternalColumnSegmentBase<TInMemory, TAtRest> {
    private final Function<TInMemory, TAtRest> convertToAtRest;
    private final Function<TAtRest, TInMemory> convertToInMemory;

    protected ColumnSegmentWithRowOrderValues(Function<TInMemory, TAtRest> convertToAtRest, Function<TAtRest, TInMemory> convertToInMemory) {
        this.convertToAtRest = convertToAtRest;
        this.convertToInMemory = convertToInMemory;
    }

    protected void ingest(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, Consumer<TAtRest[]> rowOrderValuesConsumer, Consumer<TAtRest> minConsumer, Consumer<TAtRest> maxConsumer, Consumer<Boolean> emptyExistsConsumer, Class<TAtRest> atRestClass) {
        boolean minMaxAssigned = false;
        Comparable inMemoryMin = null;
        Comparable inMemoryMax = null;
        boolean emptyExists = false;
        Comparable[] rowOrderValues = (Comparable[])Array.newInstance(atRestClass, numRowsInSegment);
        for (Map.Entry<TInMemory, List<Integer>> valuesAndRowsEntry : valuesAndRows.entrySet()) {
            Comparable key = (Comparable)valuesAndRowsEntry.getKey();
            Comparable atRestValue = (Comparable)this.convertToAtRest.apply(key);
            for (int row : valuesAndRowsEntry.getValue()) {
                rowOrderValues[row] = atRestValue;
                if (this.isValueEmpty(atRestValue)) {
                    emptyExists = true;
                    continue;
                }
                if (minMaxAssigned) {
                    inMemoryMin = inMemoryMin.compareTo(key) < 0 ? inMemoryMin : key;
                    inMemoryMax = inMemoryMax.compareTo(key) > 0 ? inMemoryMax : key;
                    continue;
                }
                inMemoryMin = inMemoryMax = key;
                minMaxAssigned = true;
            }
        }
        Comparable min2 = (Comparable)this.convertToAtRest.apply(inMemoryMin);
        Comparable max = (Comparable)this.convertToAtRest.apply(inMemoryMax);
        rowOrderValuesConsumer.accept(rowOrderValues);
        minConsumer.accept(min2);
        maxConsumer.accept(max);
        emptyExistsConsumer.accept(emptyExists);
    }

    protected abstract TAtRest[] rowOrderValues();

    protected abstract boolean isValueEmpty(TAtRest var1);

    protected abstract String valueToString(TAtRest var1);

    protected TAtRest get(int index) {
        return (TAtRest)this.rowOrderValues()[index];
    }

    @Override
    public TAtRest atRestValueForIndex(int index) {
        return this.get(index);
    }

    @Override
    public TInMemory inMemoryValueForIndex(int index) {
        return (TInMemory)((Comparable)this.convertToInMemory.apply(this.get(index)));
    }

    @Override
    public String stringValueForIndex(int index) {
        return this.valueToString(this.get(index));
    }

    @Override
    public IBitArray applyFilter(InternalColumnSegmentFilterBase filter) {
        BitArray rowLevelResults = new BitArray(this.count());
        for (int i = 0; i < this.count(); ++i) {
            if (!filter.passesFilter(this.get(i))) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }

    public IBitArray applyFilter(ComparisonFilterDefinition<TInMemory, TAtRest> comparisonFilterDefinition) {
        Object marshalledOperand = this.marshall(comparisonFilterDefinition.getOperand());
        Optional<IBitArray> shortCutResult = comparisonFilterDefinition.attemptSegmentLevelShortcut(this, (Comparable)marshalledOperand);
        if (shortCutResult.isPresent()) {
            return shortCutResult.get();
        }
        BitArray rowLevelResults = new BitArray(this.count());
        Comparable[] rowOrderValues = this.rowOrderValues();
        for (int i = 0; i < this.count(); ++i) {
            if (this.isValueEmpty(rowOrderValues[i]) || !comparisonFilterDefinition.apply((Comparable)this.convertToInMemory.apply(rowOrderValues[i]), (Comparable)marshalledOperand)) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }

    public IBitArray applyFilter(NullityFilterDefinition<TInMemory, TAtRest> nullityFilterDefinition) {
        Comparable[] rowOrderValues = this.rowOrderValues();
        switch (nullityFilterDefinition.getKind()) {
            case IsNull: {
                if (!this.getEmptyExists()) {
                    return new AllFalseBitArray(this.count());
                }
                BitArray rowLevelResults = new BitArray(this.count());
                for (int i = 0; i < this.count(); ++i) {
                    if (!this.isValueEmpty(rowOrderValues[i])) continue;
                    rowLevelResults.set(i, true);
                }
                return rowLevelResults.toReadOnly();
            }
            case IsNotNull: {
                if (!this.getEmptyExists()) {
                    return new AllTrueBitArray(this.count());
                }
                BitArray rowLevelResults = new BitArray(this.count());
                for (int i = 0; i < this.count(); ++i) {
                    if (this.isValueEmpty(rowOrderValues[i])) continue;
                    rowLevelResults.set(i, true);
                }
                return rowLevelResults.toReadOnly();
            }
        }
        throw new UnreachableCodeException();
    }

    public IBitArray applyFilter(StringFilterDefinition<TInMemory, TAtRest> stringFilterDefinition) {
        BitArray rowLevelResults = new BitArray(this.count());
        Comparable[] rowOrderValues = this.rowOrderValues();
        for (int i = 0; i < this.count(); ++i) {
            String s2;
            String string = s2 = this.isValueEmpty(rowOrderValues[i]) ? "" : this.valueToString(rowOrderValues[i]);
            if (!stringFilterDefinition.applyFilter(s2)) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }

    @Override
    protected ComparisonFilter<TInMemory, TAtRest> createComparisonFilter() {
        return new ApplyComparisonFilterToRowOrderDataColumnSegment(this);
    }

    @Override
    protected NullityFilter<TInMemory, TAtRest> createNullityFilter() {
        return new ApplyNullityFilterToRowOrderDataColumnSegment(this);
    }

    @Override
    protected StringFilter<TInMemory, TAtRest> createStringFilter() {
        return new ApplyStringFilterToRowOrderDataColumnSegment(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rowOrderValues());
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ColumnSegmentWithRowOrderValues otherColumnSegment = (ColumnSegmentWithRowOrderValues)other;
        return new EqualsBuilder().append((Object[])this.rowOrderValues(), (Object[])otherColumnSegment.rowOrderValues()).isEquals();
    }
}

