/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ColumnSegmentBuilderHint {
    public static final Map<Integer, String> Descriptions = ImmutableMap.builder().put(1, "Fast output generation with some file size reduction - simple data exchange where speed and small output size are both priorities").put(2, "Smallest possible output file size - simple data exchange where small output size is the priority").put(3, "Small output size with minimal search indexes - data exchange and edge data with minor gains in query performance").put(4, "Small output size with minimal search indexes - data exchange and edge data with incrementally greater gains in query performance").put(5, "Small output size with minimal search indexes - data exchange and edge data with incrementally greater gains in query performance").put(6, "Medium output size with light search indexes - data exchange and edge data with incrementally greater gains in query performance").put(7, "Medium output size with light search indexes - data exchange and edge data with incrementally greater gains in query performance").put(8, "Medium output size with light search indexes - data exchange and edge data with incrementally greater gains in query performance").put(9, "Medium output size with light search indexes - data exchange and edge data with incrementally greater gains in query performance").put(10, "Larger output size with moderate search indexes - for more demanding query environments").put(11, "Larger output size with moderate search indexes - for even more demanding query environments").put(12, "Larger output size with moderate search indexes - for even more demanding query environments").put(13, "Larger output size with comprehensive search indexes - for stand-alone data warehouse extracts and similar usages").put(14, "Larger output size with comprehensive search indexes - for stand-alone data warehouse extracts and similar usages").put(15, "Largest output size with fullest search indexes - for the most demanding query environments").build();
    public static final int FastestPossibleOutputFile = 0;
    public static final int AttemptedSmallestPossibleOutputFile = 1;
    public static final int GuaranteedSmallestPossibleOutputFile = 2;
    public static final int LowestHintPermittingAttemptAtIndex = 3;
    public static final int AlwaysIndex = 15;
    private final int hint;

    public ColumnSegmentBuilderHint(int hint) {
        this.hint = hint;
    }

    public int hint() {
        return this.hint;
    }

    public static ColumnSegmentBuilderHint fastestPossible() {
        return new ColumnSegmentBuilderHint(0);
    }

    public static ColumnSegmentBuilderHint smallestPossible() {
        return new ColumnSegmentBuilderHint(2);
    }

    public static ColumnSegmentBuilderHint light() {
        return new ColumnSegmentBuilderHint(6);
    }

    public static ColumnSegmentBuilderHint moderate() {
        return new ColumnSegmentBuilderHint(10);
    }

    public static ColumnSegmentBuilderHint heavy() {
        return new ColumnSegmentBuilderHint(13);
    }

    public static ColumnSegmentBuilderHint everything() {
        return new ColumnSegmentBuilderHint(15);
    }
}

