/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.UnreachableCodeException;
import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ComparisonFilterDefinition<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements FilterDefinition<TInMemory, TAtRest> {
    private final Kind kind;
    private final Object operand;
    private final BiFunction<TInMemory, TInMemory, Boolean> filter;

    public ComparisonFilterDefinition(Kind kind, Object operand) {
        this.kind = kind;
        this.operand = operand;
        switch (kind) {
            case LessThan: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) < 0;
                break;
            }
            case LessThanOrEqual: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) <= 0;
                break;
            }
            case Equal: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) == 0;
                break;
            }
            case NotEqual: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) != 0;
                break;
            }
            case GreaterThanOrEqual: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) >= 0;
                break;
            }
            case GreaterThan: {
                this.filter = (value, marshalledOperand) -> value.compareTo(marshalledOperand) > 0;
                break;
            }
            default: {
                throw new UnreachableCodeException();
            }
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public Object getOperand() {
        return this.operand;
    }

    @Override
    public int priority() {
        switch (this.kind) {
            case Equal: 
            case NotEqual: {
                return 2;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown priority");
    }

    @Override
    public FilterDefinition<TInMemory, TAtRest> simplify() {
        return this;
    }

    public boolean apply(TInMemory value, TInMemory marshalledOperand) {
        return this.filter.apply(value, marshalledOperand);
    }

    public Optional<IBitArray> attemptSegmentLevelShortcut(InternalColumnSegmentBase<TInMemory, TAtRest> segment, TInMemory marshalledOperand) {
        if (segment.getEmptyExists()) {
            return Optional.empty();
        }
        switch (this.getKind()) {
            case LessThan: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) >= 0) {
                    return Optional.of(new AllFalseBitArray(segment.count()));
                }
                if (((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) >= 0) break;
                return Optional.of(new AllTrueBitArray(segment.count()));
            }
            case LessThanOrEqual: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) > 0) {
                    return Optional.of(new AllFalseBitArray(segment.count()));
                }
                if (((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) >= 0) break;
                return Optional.of(new AllTrueBitArray(segment.count()));
            }
            case Equal: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) <= 0 && ((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) >= 0) break;
                return Optional.of(new AllFalseBitArray(segment.count()));
            }
            case NotEqual: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) <= 0 && ((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) >= 0) break;
                return Optional.of(new AllTrueBitArray(segment.count()));
            }
            case GreaterThanOrEqual: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) > 0) {
                    return Optional.of(new AllTrueBitArray(segment.count()));
                }
                if (((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) >= 0) break;
                return Optional.of(new AllFalseBitArray(segment.count()));
            }
            case GreaterThan: {
                if (((Comparable)segment.getMinValue().get()).compareTo(marshalledOperand) > 0) {
                    return Optional.of(new AllTrueBitArray(segment.count()));
                }
                if (((Comparable)segment.getMaxValue().get()).compareTo(marshalledOperand) > 0) break;
                return Optional.of(new AllFalseBitArray(segment.count()));
            }
            default: {
                throw new UnreachableCodeException();
            }
        }
        return Optional.empty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.kind).append(this.operand).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComparisonFilterDefinition)) {
            return false;
        }
        ComparisonFilterDefinition other = (ComparisonFilterDefinition)o;
        return new EqualsBuilder().append((Object)this.kind, (Object)other.getKind()).append(this.operand, other.getOperand()).build();
    }

    public static enum Kind {
        LessThan,
        LessThanOrEqual,
        Equal,
        NotEqual,
        GreaterThanOrEqual,
        GreaterThan;

    }
}

