/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.UnreachableCodeException;
import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.NullityFilter;
import com.exponam.core.internalColumnSegmentFilters.NullityFilterDefinition;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithOneValue;

public class ApplyNullityFilterToOneValueColumnSegment<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements NullityFilter<TInMemory, TAtRest> {
    private final ColumnSegmentWithOneValue<TInMemory, TAtRest> segment;

    public ApplyNullityFilterToOneValueColumnSegment(ColumnSegmentWithOneValue<TInMemory, TAtRest> segment) {
        this.segment = segment;
    }

    @Override
    public IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        NullityFilterDefinition nullityFilterDefinition = (NullityFilterDefinition)filterDefinition;
        switch (nullityFilterDefinition.getKind()) {
            case IsNull: {
                return this.segment.isSingleValueEmpty() ? new AllTrueBitArray(this.segment.count()).toReadOnly() : new AllFalseBitArray(this.segment.count()).toReadOnly();
            }
            case IsNotNull: {
                return !this.segment.isSingleValueEmpty() ? new AllTrueBitArray(this.segment.count()).toReadOnly() : new AllFalseBitArray(this.segment.count()).toReadOnly();
            }
        }
        throw new UnreachableCodeException();
    }
}

