/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilter;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import java.util.Optional;

public class ApplyComparisonFilterToSortedValuesColumnSegment<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements ComparisonFilter<TInMemory, TAtRest> {
    private final ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment;
    private final int firstNonEmptySortedValueIndex;

    public ApplyComparisonFilterToSortedValuesColumnSegment(ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment) {
        this.segment = segment;
        this.firstNonEmptySortedValueIndex = segment.getEmptyExists() ? 1 : 0;
    }

    @Override
    public IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        ComparisonFilterDefinition comparisonFilterDefinition = (ComparisonFilterDefinition)filterDefinition;
        Object marshalledOperand = this.segment.marshall(comparisonFilterDefinition.getOperand());
        Optional<IBitArray> shortCutResult = comparisonFilterDefinition.attemptSegmentLevelShortcut(this.segment, marshalledOperand);
        if (shortCutResult.isPresent()) {
            return shortCutResult.get();
        }
        int operandIndex = -1;
        switch (comparisonFilterDefinition.getKind()) {
            case LessThanOrEqual: {
                operandIndex = this.indexForValue(marshalledOperand);
            }
            case LessThan: {
                if (operandIndex == -1) {
                    operandIndex = this.indexForLessThanValue(marshalledOperand);
                }
                if (operandIndex == -1) {
                    return this.getAllFalseBitArray();
                }
                if (operandIndex == this.segment.sortedValues().length - 1) {
                    return this.getAllTrueBitArray();
                }
                BitArray ba = new BitArray(this.segment.count());
                this.segment.doForSpecificSortedItemsIndexes(this.firstNonEmptySortedValueIndex, operandIndex, row -> ba.set((int)row, true));
                return ba.toReadOnly();
            }
            case Equal: {
                operandIndex = this.indexForValue(marshalledOperand);
                if (operandIndex == -1) {
                    return this.getAllFalseBitArray();
                }
                BitArray bitArray = new BitArray(this.segment.count());
                this.populateBitArrayForRows(bitArray, operandIndex, true);
                return bitArray.toReadOnly();
            }
            case NotEqual: {
                operandIndex = this.indexForValue(marshalledOperand);
                if (operandIndex == -1) {
                    return this.getAllTrueBitArray();
                }
                BitArray bitArray = new BitArray(this.segment.count(), true);
                this.populateBitArrayForRows(bitArray, operandIndex, false);
                return bitArray.toReadOnly();
            }
            case GreaterThanOrEqual: {
                operandIndex = this.indexForValue(marshalledOperand);
            }
            case GreaterThan: {
                if (operandIndex == -1) {
                    operandIndex = this.indexForGreaterThanValue(marshalledOperand);
                }
                if (operandIndex == -1) {
                    return this.getAllFalseBitArray();
                }
                if (operandIndex == this.firstNonEmptySortedValueIndex) {
                    return this.getAllTrueBitArray();
                }
                BitArray ba = new BitArray(this.segment.count());
                this.segment.doForSpecificSortedItemsIndexes(operandIndex, this.segment.sortedValues().length - 1, row -> ba.set((int)row, true));
                return ba.toReadOnly();
            }
        }
        throw new IllegalArgumentException("Unknown filter kind");
    }

    private void populateBitArrayForRows(BitArray bitArray, int sortedValuesIndex, boolean bitValue) {
        this.segment.doForSpecificSortedItemIndex(sortedValuesIndex, row -> bitArray.set((int)row, bitValue));
    }

    private IBitArray getAllFalseBitArray() {
        return new AllFalseBitArray(this.segment.count()).toReadOnly();
    }

    private IBitArray getAllTrueBitArray() {
        if (this.firstNonEmptySortedValueIndex == 0) {
            return new AllTrueBitArray(this.segment.count()).toReadOnly();
        }
        BitArray bitArray = new BitArray(this.segment.count(), true);
        this.populateBitArrayForRows(bitArray, 0, false);
        return bitArray.toReadOnly();
    }

    private int indexForValue(TInMemory operand) {
        int start = this.firstNonEmptySortedValueIndex;
        int end = this.segment.sortedValues().length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            Comparable valueAtMid = (Comparable)this.segment.convertToInMemory().apply(this.segment.sortedValues()[mid]);
            int comparisonResult = valueAtMid.compareTo(operand);
            if (comparisonResult == 0) {
                return mid;
            }
            if (comparisonResult > 0) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return -1;
    }

    private int indexForGreaterThanValue(TInMemory operand) {
        int start = this.firstNonEmptySortedValueIndex;
        int result = -1;
        int end = this.segment.sortedValues().length;
        while (start <= end) {
            int mid = (start + end) / 2;
            Comparable valueAtMid = (Comparable)this.segment.convertToInMemory().apply(this.segment.sortedValues()[mid]);
            int comparisonResult = valueAtMid.compareTo(operand);
            if (comparisonResult <= 0) {
                start = mid + 1;
                continue;
            }
            result = mid;
            end = mid - 1;
        }
        return result;
    }

    private int indexForLessThanValue(TInMemory operand) {
        int start = this.firstNonEmptySortedValueIndex;
        int result = -1;
        int end = this.segment.sortedValues().length;
        while (start <= end) {
            int mid = (start + end) / 2;
            Comparable valueAtMid = (Comparable)this.segment.convertToInMemory().apply(this.segment.sortedValues()[mid]);
            int comparisonResult = valueAtMid.compareTo(operand);
            if (comparisonResult >= 0) {
                end = mid - 1;
                continue;
            }
            result = mid;
            start = mid + 1;
        }
        return result;
    }
}

