/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.crypto;

import com.exponam.core.InternalMetadatum;
import com.exponam.core.crypto.CryptoUtilities;
import com.exponam.core.crypto.IDecryptor;
import com.exponam.core.reader.BigReader;
import java.io.IOException;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.lang3.StringUtils;

public class DecryptionUtilities {
    private static IDecryptor createDecryptor(String password, String saltAsBase64) {
        return new AESDecryptor(CryptoUtilities.createCipher(password, saltAsBase64, false));
    }

    public static Supplier<IDecryptor> setupDecryptionForPassword(String password, BigReader bigReader) throws IOException {
        Supplier<IDecryptor> decryptorSupplier = () -> x -> x;
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            String hashedAttemptedPassword;
            InternalMetadatum saltMetadatum = (InternalMetadatum)bigReader.getMetadataReader().getSingleMetadatum("ExponamSalt", true, true).getRight();
            if (saltMetadatum == null) {
                throw new IllegalArgumentException("Password supplied for file that is not encrypted");
            }
            InternalMetadatum hashedPasswordMetadatum = (InternalMetadatum)bigReader.getMetadataReader().getSingleMetadatum("ExponamPwd", true, true).getRight();
            if (hashedPasswordMetadatum == null) {
                throw new IllegalArgumentException("The file is corrupt and cannot be opened");
            }
            String salt = saltMetadatum.getValueAsString();
            String originalHashedPassword = hashedPasswordMetadatum.getValueAsString();
            if (!originalHashedPassword.equals(hashedAttemptedPassword = CryptoUtilities.hashPassword(password, salt))) {
                throw new IllegalArgumentException("Incorrect password");
            }
            decryptorSupplier = () -> DecryptionUtilities.createDecryptor(password, salt);
        }
        return decryptorSupplier;
    }

    static class AESDecryptor
    implements IDecryptor {
        private final Cipher cipher;

        AESDecryptor(Cipher cipher) {
            this.cipher = cipher;
        }

        @Override
        public byte[] decrypt(byte[] ciphertext) {
            try {
                return this.cipher.doFinal(ciphertext);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new RuntimeException("Unable to perform AES decryption", e);
            }
        }
    }
}

