/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import com.exponam.core.Codec;
import com.exponam.core.InternalExtrasXRefReadable;
import com.exponam.core.InternalMetadatum;
import com.exponam.core.InternalPrivateTrailerReadable;
import com.exponam.core.InternalTrailer;
import com.exponam.core.InternalXRefReadable;
import com.exponam.core.crypto.IDecryptor;
import com.exponam.core.protobuf.trailer.Metadatum;
import com.exponam.core.protobuf.trailer.MetadatumList;
import com.exponam.core.protobuf.trailer.PrivateTrailer;
import com.exponam.core.protobuf.trailer.Trailer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalTrailerReadable
extends InternalTrailer {
    private final byte[] privateTrailerAsBytes;
    private InternalPrivateTrailerReadable privateTrailer;

    private InternalTrailerReadable(Trailer protoTrailer) {
        super(InternalTrailerReadable.metadataFromProto(protoTrailer), new InternalXRefReadable(protoTrailer.getXref()), new InternalExtrasXRefReadable(protoTrailer.getExtrasXref()), protoTrailer.getDocUUID());
        this.privateTrailerAsBytes = protoTrailer.getPrivateTrailerAsBytes().toByteArray();
        this.privateTrailer = null;
    }

    public InternalXRefReadable getXRefReadable() {
        return (InternalXRefReadable)this.getXRef();
    }

    public InternalPrivateTrailerReadable getPrivateTrailerReadable(IDecryptor decryptor) throws IOException {
        if (this.privateTrailer == null) {
            byte[] decrypted = decryptor.decrypt(this.getPrivateTrailerAsBytes());
            byte[] decompressed = Codec.decompress(decrypted);
            PrivateTrailer protoPrivateTrailer = PrivateTrailer.parseFrom(decompressed);
            this.privateTrailer = new InternalPrivateTrailerReadable(protoPrivateTrailer);
        }
        return this.privateTrailer;
    }

    public static InternalTrailerReadable decompressAndDeserialize(byte[] bytes) throws IOException {
        byte[] decompressedBytes = Codec.decompress(bytes);
        Trailer t = Trailer.parseFrom(decompressedBytes);
        return new InternalTrailerReadable(t);
    }

    @Override
    protected byte[] getPrivateTrailerAsBytes() {
        return this.privateTrailerAsBytes;
    }

    private static Map<String, List<InternalMetadatum>> metadataFromProto(Trailer protoTrailer) {
        HashMap<String, List<InternalMetadatum>> metadata = new HashMap<String, List<InternalMetadatum>>();
        for (Map.Entry<String, MetadatumList> entry : protoTrailer.getPublicMetadataMap().entrySet()) {
            ArrayList<InternalMetadatum> internalMetadatumList = new ArrayList<InternalMetadatum>();
            for (Metadatum protoMetadatum : entry.getValue().getMetadatumListList()) {
                internalMetadatumList.add(new InternalMetadatum(protoMetadatum));
            }
            metadata.put(entry.getKey(), internalMetadatumList);
        }
        return metadata;
    }
}

