/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import com.exponam.core.protobuf.trailer.AssignedCategory;
import com.exponam.core.protobuf.trailer.Metadatum;
import com.exponam.core.protobuf.trailer.UserVisibility;
import com.google.common.net.MediaType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class InternalMetadatum {
    private final AssignedCategory category;
    private final UserVisibility userVisible;
    private final String name;
    private final String mimeType;
    private final byte[] value;

    public InternalMetadatum(AssignedCategory category, UserVisibility userVisible, String name, String value) {
        this(category, userVisible, name, value, MediaType.PLAIN_TEXT_UTF_8.toString());
    }

    public InternalMetadatum(AssignedCategory category, UserVisibility userVisible, String name, String value, String mimeType) {
        this.category = category;
        this.userVisible = userVisible;
        this.name = name;
        this.mimeType = mimeType;
        this.value = value.getBytes();
    }

    public InternalMetadatum(AssignedCategory category, UserVisibility userVisible, String name, byte[] value, String mimeType) {
        this.category = category;
        this.userVisible = userVisible;
        this.name = name;
        this.mimeType = mimeType;
        this.value = value;
    }

    InternalMetadatum(Metadatum protoMetadatum) {
        this.category = protoMetadatum.getCategory();
        this.userVisible = protoMetadatum.getUserVisible();
        this.name = protoMetadatum.getName();
        this.mimeType = protoMetadatum.getMimeType();
        this.value = protoMetadatum.getValue().toByteArray();
    }

    public AssignedCategory getCategory() {
        return this.category;
    }

    boolean isUserVisible() {
        return this.userVisible == UserVisibility.Visible;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return new String(this.value);
    }

    public UserVisibility getUserVisible() {
        return this.userVisible;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.category).append((Object)this.userVisible).append((Object)this.name).append((Object)this.mimeType).append(this.value).build();
    }

    public boolean equals(Object o) {
        if (!(o instanceof InternalMetadatum)) {
            return false;
        }
        InternalMetadatum other = (InternalMetadatum)o;
        return new EqualsBuilder().append((Object)this.category, (Object)other.category).append((Object)this.userVisible, (Object)other.userVisible).append((Object)this.name, (Object)other.name).append((Object)this.mimeType, (Object)other.mimeType).append(this.value, other.value).isEquals();
    }
}

