/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.api.reader;

import com.exponam.api.reader.FilterTranslation;
import com.exponam.api.reader.QueryColumn;
import com.exponam.core.crypto.DecryptionUtilities;
import com.exponam.core.reader.BigReader;
import com.exponam.core.reader.Marshaller;
import com.exponam.core.reader.QueryColumnAttributes;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Reader
implements Closeable {
    private BigReader bigReader;
    private final Marshaller marshaller;

    public Reader(File bigFile, Supplier<String> passwordSupplier) throws IOException, BigReader.UnsupportedFileVersionException {
        File validatedBigFile = Reader.validateBigFileParameter(bigFile);
        this.bigReader = new BigReader(new FileInputStream(validatedBigFile));
        String password = passwordSupplier == null ? "" : passwordSupplier.get();
        this.bigReader.setDecryptor(DecryptionUtilities.setupDecryptionForPassword(password, this.bigReader).get());
        this.marshaller = new Marshaller(this.bigReader);
    }

    public int getWorksheetCount() {
        return 1;
    }

    public String getWorksheetName(int worksheetIndex) {
        this.validateWorksheetIndex(worksheetIndex);
        return "Worksheet";
    }

    public int getRowCount(int worksheetIndex) {
        this.validateWorksheetIndex(worksheetIndex);
        return this.bigReader.getWorksheet(worksheetIndex).getNumRows();
    }

    public int getColumnCount(int worksheetIndex) {
        this.validateWorksheetIndex(worksheetIndex);
        return this.bigReader.getWorksheet(worksheetIndex).getColumns().count();
    }

    public String getColumnName(int worksheetIndex, int columnIndex) {
        this.validateWorksheetAndColumnIndex(worksheetIndex, columnIndex);
        return this.bigReader.getWorksheet(worksheetIndex).getColumns().get(columnIndex).getName();
    }

    public ColumnTypes getColumnType(int worksheetIndex, int columnIndex) {
        this.validateWorksheetAndColumnIndex(worksheetIndex, columnIndex);
        switch (this.bigReader.getWorksheet(worksheetIndex).getColumns().get(columnIndex).getType()) {
            case Boolean: {
                return ColumnTypes.Boolean;
            }
            case Date: {
                return ColumnTypes.Date;
            }
            case DateTime: {
                return ColumnTypes.DateTime;
            }
            case Double: {
                return ColumnTypes.Double;
            }
            case Long: {
                return ColumnTypes.Long;
            }
            case String: {
                return ColumnTypes.String;
            }
            case Time: {
                return ColumnTypes.Time;
            }
        }
        throw new IllegalArgumentException("Unknown column type");
    }

    public <T> T getValue(int worksheetIndex, int rowIndex, int columnIndex, Type desiredClass) {
        this.validateWorksheetColumnAndRowIndex(worksheetIndex, rowIndex, columnIndex);
        Objects.requireNonNull(desiredClass, "desiredClass");
        return this.marshaller.getColumnValueAs(worksheetIndex, rowIndex, columnIndex, desiredClass);
    }

    public void getRowValues(int worksheetIndex, int startRow, int endRow, Map<Integer, QueryColumn> queryColumns, BiConsumer<Integer, Function<Integer, Object>> rowConsumer) {
        this.validateWorksheetIndex(worksheetIndex);
        if (startRow < 0) {
            throw new IllegalArgumentException("Start row must be >= 0");
        }
        if (endRow >= this.getRowCount(worksheetIndex)) {
            throw new IllegalArgumentException(String.format("End row must be < %d", this.getRowCount(worksheetIndex)));
        }
        if (startRow > endRow) {
            throw new IllegalArgumentException("Start row must be <= end row");
        }
        Objects.requireNonNull(queryColumns, "queryColumns");
        if (queryColumns.isEmpty()) {
            throw new IllegalArgumentException("queryColumns cannot be empty");
        }
        Map<Integer, QueryColumnAttributes> internalQueryColumns = queryColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new QueryColumnAttributes(((QueryColumn)entry.getValue()).getProject(), ((QueryColumn)entry.getValue()).getDesiredType(), ((QueryColumn)entry.getValue()).getColumnFilter().map(FilterTranslation::map))));
        this.marshaller.fetchRows(worksheetIndex, startRow, endRow, internalQueryColumns, rowConsumer);
    }

    @Override
    public void close() throws IOException {
        if (this.bigReader != null) {
            this.bigReader.close();
            this.bigReader = null;
        }
    }

    private static File validateBigFileParameter(File bigFile) {
        Objects.requireNonNull(bigFile, "bigFile");
        if (bigFile.isDirectory()) {
            throw new IllegalArgumentException(String.format("'%s' is a directory.", bigFile.getName()));
        }
        if (!bigFile.exists()) {
            throw new IllegalArgumentException(String.format("'%s' does not exist", bigFile.getName()));
        }
        return bigFile;
    }

    private void validateWorksheetIndex(int worksheetIndex) {
        if (worksheetIndex < 0 || worksheetIndex >= this.getWorksheetCount()) {
            throw new IllegalArgumentException(String.format("Worksheet index '%d' out of range", worksheetIndex));
        }
    }

    private void validateWorksheetAndColumnIndex(int worksheetIndex, int columnIndex) {
        this.validateWorksheetIndex(worksheetIndex);
        if (columnIndex < 0 || columnIndex >= this.getColumnCount(worksheetIndex)) {
            throw new IllegalArgumentException(String.format("Column index '%d' out of range", columnIndex));
        }
    }

    private void validateWorksheetColumnAndRowIndex(int worksheetIndex, int rowIndex, int columnIndex) {
        this.validateWorksheetAndColumnIndex(worksheetIndex, columnIndex);
        if (rowIndex < 0 || rowIndex >= this.getRowCount(worksheetIndex)) {
            throw new IllegalArgumentException(String.format("Row index '%d' out of range", rowIndex));
        }
    }

    public static enum ColumnTypes {
        Boolean,
        Date,
        DateTime,
        Double,
        Long,
        String,
        Time;

    }
}

