/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumns;

import com.exponam.core.Codec;
import com.exponam.core.crypto.IEncryptor;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.internalColumns.InternalColumn;
import com.exponam.core.protobuf.trailer.Column;
import com.exponam.core.protobuf.trailer.ColumnGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InternalColumnGroup {
    private final List<InternalColumn> columns;

    public InternalColumnGroup(List<InternalColumn> columns) {
        this.columns = columns;
    }

    public InternalColumnGroup(ColumnGroup protoColumnGroup) {
        this.columns = new ArrayList<InternalColumn>();
        for (Column protoColumn : protoColumnGroup.getColumnsList()) {
            this.columns.add(new InternalColumn(protoColumn));
        }
    }

    public int count() {
        return this.columns.size();
    }

    public InternalColumn get(int index) {
        return this.columns.get(index);
    }

    public int indexOf(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public List<String> columnNames() {
        return this.columns.stream().map(InternalColumn::getName).collect(Collectors.toList());
    }

    public byte[] serializeAndCompressAndMaybeEncrypt(Supplier<IEncryptor> encryptor) throws IOException {
        ColumnGroup protoColumnGroup = this.toProtobufRepresentation();
        byte[] protoColumnGroupAsBytes = protoColumnGroup.toByteArray();
        byte[] compressedProtoColumnGroupAsBytes = Codec.compress(protoColumnGroupAsBytes);
        return encryptor.get().encrypt(compressedProtoColumnGroupAsBytes);
    }

    public ColumnGroup toProtobufRepresentation() {
        ColumnGroup.Builder columnGroupBuilder = ColumnGroup.newBuilder();
        for (InternalColumn internalColumn : this.columns) {
            Column.Builder columnBuilder = Column.newBuilder();
            columnBuilder = columnBuilder.setType(this.internalColumnTypeToProto(internalColumn.getType()));
            columnBuilder = columnBuilder.setName(internalColumn.getName());
            columnBuilder = columnBuilder.putAllProperties(internalColumn.getProperties());
            Column protoColumn = columnBuilder.build();
            columnGroupBuilder = columnGroupBuilder.addColumns(protoColumn);
        }
        return columnGroupBuilder.build();
    }

    private com.exponam.core.protobuf.trailer.ColumnTypes internalColumnTypeToProto(ColumnTypes internalColumnType) {
        switch (internalColumnType) {
            case String: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.String;
            }
            case Double: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.Double;
            }
            case Long: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.Long;
            }
            case Date: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.Date;
            }
            case DateTime: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.DateTime;
            }
            case Boolean: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.Boolean;
            }
            case Time: {
                return com.exponam.core.protobuf.trailer.ColumnTypes.Time;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown column type %s", internalColumnType.toString()));
    }
}

