/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.times;

import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.times.ExponamTime;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.TimeWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Map;

public class InternalTimeWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<ExponamTime, Integer> {
    private final int numValues;
    private Integer minValue;
    private Integer maxValue;
    private boolean emptyExists;
    private Integer[] rowOrderValues;

    InternalTimeWithRowOrderDataColumnSegment(int numRowsInSegment, Map<ExponamTime, List<Integer>> valuesAndRows) {
        super(InternalTimeColumnSegmentUtilities.toAtRest, InternalTimeColumnSegmentUtilities.toInMemory);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, Integer.class);
    }

    InternalTimeWithRowOrderDataColumnSegment(TimeWithRowOrderDataColumnSegment protoSegment) {
        super(InternalTimeColumnSegmentUtilities.toAtRest, InternalTimeColumnSegmentUtilities.toInMemory);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinValue();
        this.maxValue = protoSegment.getMaxValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = protoSegment.getRowOrderValuesList().toArray(new Integer[0]);
    }

    protected Integer[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(Integer value) {
        return value.equals(InternalTimeColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Integer value) {
        return InternalTimeColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ColumnSegmentBase toProto() {
        TimeWithRowOrderDataColumnSegment protoSegment = TimeWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinValue(this.minValue).setMaxValue(this.maxValue).setEmptyExists(this.emptyExists).addAllRowOrderValues(() -> Iterators.forArray(this.rowOrderValues)).build();
        return ColumnSegmentBase.newBuilder().mergeTimeWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

