/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.internalColumnSegments.datetimes.ExponamDateTime;
import com.exponam.core.internalColumns.InternalColumn;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class InternalDateTimeColumnSegmentUtilities {
    public static final ExponamDateTime EmptyDateTime = new ExponamDateTime(0L);
    public static final Long Empty = EmptyDateTime.getDateTimeInCSharpTicks();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static Function<ExponamDateTime, Long> toAtRest = InternalDateTimeColumnSegmentUtilities::sinceDateBasis;
    static Function<Long, ExponamDateTime> toInMemory = InternalDateTimeColumnSegmentUtilities::dateTimeSinceDateBasis;
    public static BiFunction<Long, InternalColumn, String> atRestToString = (value, column) -> {
        if (value.equals(Empty)) {
            return "";
        }
        ExponamDateTime exponamDateTime = InternalDateTimeColumnSegmentUtilities.dateTimeSinceDateBasis(value);
        Timestamp datetime = exponamDateTime.toSqlTimestamp();
        if (StringUtils.isEmpty((CharSequence)column.getJavaCompatibleDisplayMask())) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.format(datetime);
            }
        }
        SimpleDateFormat displaySdf = new SimpleDateFormat(column.getJavaCompatibleDisplayMask());
        return displaySdf.format(datetime);
    };

    private static Long sinceDateBasis(ExponamDateTime date) {
        return date.getDateTimeInCSharpTicks();
    }

    private static ExponamDateTime dateTimeSinceDateBasis(Long cSharpTicks) {
        return new ExponamDateTime(cSharpTicks);
    }
}

