/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExponamDateTime
implements Serializable,
Comparable<ExponamDateTime> {
    private static final long PLATFORM_DIFFERENCE_IN_CSHARP_TICKS = 621355968000000000L;
    private static final long MILLIS_TO_TICKS_MULTIPLIER = 10000L;
    private static final long PLATFORM_DIFFERENCE_IN_MILLIS = 62135596800000L;
    private final long dateTimeInCSharpTicks;

    public ExponamDateTime(long dateTimeInCSharpTicks) {
        this.dateTimeInCSharpTicks = dateTimeInCSharpTicks;
    }

    public static ExponamDateTime fromMillisInvariantWithTimezone(long dateTimeIn1970BasedMillis) {
        Instant dateInstant = Instant.ofEpochMilli(dateTimeIn1970BasedMillis);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(dateInstant);
        int totalSeconds = zoneOffset.getTotalSeconds();
        long dateTimeInCSharpMillis = (dateTimeIn1970BasedMillis += (long)totalSeconds * 1000L) + 62135596800000L;
        long dateTimeInCSharpTicks = dateTimeInCSharpMillis * 10000L;
        return new ExponamDateTime(dateTimeInCSharpTicks);
    }

    public static ExponamDateTime fromDate(Timestamp date) {
        long l = date.getTime();
        Instant dateInstant = Instant.ofEpochMilli(l += 62135596800000L);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(dateInstant);
        int totalSeconds = zoneOffset.getTotalSeconds();
        l += (long)totalSeconds * 1000L;
        return new ExponamDateTime(l *= 10000L);
    }

    public long getDateTimeInCSharpTicks() {
        return this.dateTimeInCSharpTicks;
    }

    public long getDateTimeInMillis() {
        long dateTimeInCSharpMillis = this.dateTimeInCSharpTicks / 10000L;
        long dateTimeIn1970BasedMillis = dateTimeInCSharpMillis - 62135596800000L;
        return dateTimeIn1970BasedMillis;
    }

    public long getDateTimeInMillisInvariantWithTimezone() {
        long dateTimeInCSharpMillis = this.dateTimeInCSharpTicks / 10000L;
        long dateTimeIn1970BasedMillis = dateTimeInCSharpMillis - 62135596800000L;
        Instant dateInstant = Instant.ofEpochMilli(dateTimeIn1970BasedMillis);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(dateInstant);
        int totalSeconds = zoneOffset.getTotalSeconds();
        return dateTimeIn1970BasedMillis -= (long)totalSeconds * 1000L;
    }

    public Timestamp toSqlTimestamp() {
        if (this.dateTimeInCSharpTicks == InternalDateTimeColumnSegmentUtilities.Empty) {
            return new Timestamp(-1L);
        }
        return new Timestamp(this.getDateTimeInMillisInvariantWithTimezone());
    }

    @Override
    public int compareTo(ExponamDateTime o) {
        return Long.compare(this.dateTimeInCSharpTicks, o.getDateTimeInCSharpTicks());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.dateTimeInCSharpTicks).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExponamDateTime)) {
            return false;
        }
        ExponamDateTime other = (ExponamDateTime)o;
        return this.dateTimeInCSharpTicks == other.getDateTimeInCSharpTicks();
    }
}

