/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.bool;

import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.BooleanTrueOrFalseValuesColumnSegment;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Optional;

public class InternalBooleanTrueOrFalseValuesColumnSegment
extends InternalBooleanColumnSegmentBase {
    private static final int canonicalFalse = 0;
    private static final int canonicalTrue = 1;
    private static final int greatestZeroBasedEntryValue = 1;
    private final Integer numValues;
    private final long[] values;
    private IndexedValuesBitFieldPacker bitFieldPacker;

    InternalBooleanTrueOrFalseValuesColumnSegment(List<Optional<Boolean>> values) {
        this.numValues = values.size();
        this.values = IndexedValuesBitFieldPacker.packedEntries(1, this.numValues);
        for (int i = 0; i < this.numValues; ++i) {
            this.put(i, values.get(i));
        }
    }

    InternalBooleanTrueOrFalseValuesColumnSegment(BooleanTrueOrFalseValuesColumnSegment protoSegment) {
        this.numValues = protoSegment.getNumValues();
        List<Long> protoValuesList = protoSegment.getValuesList();
        this.values = new long[protoValuesList.size()];
        for (int i = 0; i < protoValuesList.size(); ++i) {
            this.values[i] = protoValuesList.get(i);
        }
    }

    @Override
    public int count() {
        return this.numValues;
    }

    private void put(int index, Optional<Boolean> value) {
        this.getBitFieldPacker().putValueForEntry(index, InternalBooleanTrueOrFalseValuesColumnSegment.convertBoolToEntryValue(value));
    }

    @Override
    protected Optional<Boolean> get(int index) {
        return InternalBooleanTrueOrFalseValuesColumnSegment.convertEntryValueToBool(this.getBitFieldPacker().getValueForEntry(index));
    }

    private IndexedValuesBitFieldPacker getBitFieldPacker() {
        if (this.bitFieldPacker != null) {
            return this.bitFieldPacker;
        }
        this.bitFieldPacker = new IndexedValuesBitFieldPacker(this.values, 1);
        return this.bitFieldPacker;
    }

    private static int convertBoolToEntryValue(Optional<Boolean> b) {
        if (b.isPresent()) {
            return b.get().equals(Boolean.TRUE) ? 1 : 0;
        }
        throw new IllegalArgumentException("Unexpected empty boolean found");
    }

    private static Optional<Boolean> convertEntryValueToBool(int entryValue) {
        switch (entryValue) {
            case 0: {
                return Optional.of(Boolean.FALSE);
            }
            case 1: {
                return Optional.of(Boolean.TRUE);
            }
        }
        throw new IllegalArgumentException("Unrecognized entry value");
    }

    public int hashCode() {
        return this.numValues.hashCode() * 31 + this.values.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InternalBooleanTrueOrFalseValuesColumnSegment)) {
            return false;
        }
        InternalBooleanTrueOrFalseValuesColumnSegment otherSegment = (InternalBooleanTrueOrFalseValuesColumnSegment)other;
        return this.numValues.equals(otherSegment.numValues) && this.values.equals(otherSegment.values);
    }

    @Override
    public ColumnSegmentBase toProto() {
        BooleanTrueOrFalseValuesColumnSegment protoSegment = BooleanTrueOrFalseValuesColumnSegment.newBuilder().setNumValues(this.numValues).addAllValues(Longs.asList(this.values)).build();
        return ColumnSegmentBase.newBuilder().mergeBooleanTrueOrFalseValuesColumnSegment(protoSegment).build();
    }
}

