/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.Codec;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentMaker;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentMaker;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentMaker;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentMaker;
import com.exponam.core.internalColumnSegments.strings.InternalStringColumnSegmentMaker;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentMaker;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentWrapper;
import java.io.IOException;

public class ReaderUtilities {
    public static InternalColumnSegmentBase fromProto(byte[] rawBytes, ColumnTypes columnType) throws IOException {
        byte[] decompressedBytes = Codec.decompress(rawBytes);
        ColumnSegmentWrapper protoWrapper = ColumnSegmentWrapper.parseFrom(decompressedBytes);
        ColumnSegmentBase protoColumnSegmentBase = protoWrapper.getColumnSegment();
        switch (columnType) {
            case DateTime: {
                return InternalDateTimeColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
            case Date: {
                return InternalDateColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
            case Long: {
                return InternalLongColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
            case Time: {
                return InternalTimeColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
            case Double: {
                return InternalDoubleColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
            case Boolean: {
                throw new RuntimeException("Unsupported column type");
            }
            case String: {
                return InternalStringColumnSegmentMaker.fromProto(protoColumnSegmentBase);
            }
        }
        throw new RuntimeException("Unsupported column type");
    }
}

