/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilterResult;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import java.util.function.Consumer;

public class BitArray
implements IBitArray {
    private static int NUM_BITS_PER_LONG = 64;
    private static long ONE = 1L;
    private final int numElements;
    private final long[] bits;
    private int numTrue;
    private boolean finalized;

    public BitArray(int numElements) {
        this.numElements = numElements;
        this.bits = new long[BitArray.numLongsForElements(numElements)];
        this.numTrue = 0;
        this.finalized = false;
    }

    public BitArray(int numElements, long[] buffer) {
        this.numElements = numElements;
        this.bits = buffer;
        this.numTrue = BitArray.numTrue(this.bits);
        this.finalized = true;
    }

    @Override
    public int count() {
        return this.numElements;
    }

    @Override
    public void set(int element, boolean value) {
        if (this.finalized) {
            throw new IllegalArgumentException("Array has already been finalized");
        }
        if (!value) {
            return;
        }
        int indexIntoBitsArray = element / NUM_BITS_PER_LONG;
        int indexIntoBitElement = element % NUM_BITS_PER_LONG;
        long shiftedValue = ONE << indexIntoBitElement;
        int n = indexIntoBitsArray;
        this.bits[n] = this.bits[n] | shiftedValue;
        ++this.numTrue;
    }

    @Override
    public boolean get(int element) {
        if (!this.finalized) {
            throw new IllegalArgumentException("Array has not been finalized");
        }
        int indexIntoBitsArray = element / NUM_BITS_PER_LONG;
        int indexIntoBitElement = element % NUM_BITS_PER_LONG;
        long shiftedValue = this.bits[indexIntoBitsArray] >> indexIntoBitElement;
        return (shiftedValue & ONE) != 0L;
    }

    @Override
    public int numPasses() {
        if (!this.finalized) {
            throw new IllegalArgumentException("Array has not been finalized");
        }
        return this.numTrue;
    }

    @Override
    public IBitArray toReadOnly() {
        if (this.finalized) {
            throw new IllegalArgumentException("Array has already been finalized");
        }
        this.finalized = true;
        if (this.numTrue == this.count()) {
            return new AllTrueBitArray(this.numElements);
        }
        if (this.numTrue == 0) {
            return new AllFalseBitArray(this.numElements);
        }
        return this;
    }

    public IBitArray And(BitArray other) {
        if (this.count() != other.count()) {
            throw new IllegalArgumentException("Expected counts to be the same");
        }
        long[] result = new long[this.bits.length];
        for (int i = 0; i < this.bits.length; ++i) {
            result[i] = this.bits[i] & other.bits[i];
        }
        return new BitArray(this.count(), result);
    }

    public IBitArray Or(BitArray other) {
        if (this.count() != other.count()) {
            throw new IllegalArgumentException("Expected counts to be the same");
        }
        long[] result = new long[this.bits.length];
        for (int i = 0; i < this.bits.length; ++i) {
            result[i] = this.bits[i] | other.bits[i];
        }
        return new BitArray(this.count(), result);
    }

    private static int numLongsForElements(int numElements) {
        return numElements / NUM_BITS_PER_LONG + (numElements % NUM_BITS_PER_LONG > 0 ? 1 : 0);
    }

    private static int numTrue(long[] buffer) {
        int numTrue = 0;
        for (long l : buffer) {
            if (l == 0L) continue;
            long temp = l;
            for (int i = 0; i < NUM_BITS_PER_LONG; ++i) {
                if ((temp & ONE) != 0L) {
                    ++numTrue;
                }
                temp >>= 1;
            }
        }
        return numTrue;
    }

    @Override
    public int forEachPassingRow(Consumer<Integer> doToRowFunc) {
        if (!this.finalized) {
            throw new IllegalArgumentException("Array has not been finalized");
        }
        int row = 0;
        for (long l : this.bits) {
            if (l == 0L) {
                row += 64;
                continue;
            }
            long temp = l;
            for (int i = 0; i < NUM_BITS_PER_LONG; ++i) {
                if ((temp & ONE) != 0L) {
                    doToRowFunc.accept(row);
                }
                temp >>= 1;
                ++row;
            }
        }
        return this.numTrue;
    }
}

