/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.crypto;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtilities {
    private static final Random RANDOM = new SecureRandom();

    public static String generateSaltAsBase64String() {
        byte[] salt = new byte[8];
        RANDOM.nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    public static String hashPassword(String password, String salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String saltAndPassword = salt + password;
            byte[] hash = digest.digest(saltAndPassword.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static Cipher createCipher(String password, String saltAsBase64, boolean forEncryption) {
        try {
            Security.setProperty("crypto.policy", "unlimited");
            byte[] salt = Base64.getDecoder().decode(saltAsBase64);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray(), salt, 1000, 384);
            SecretKey secretKey = factory.generateSecret(pbeKeySpec);
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            System.arraycopy(secretKey.getEncoded(), 0, key, 0, 32);
            System.arraycopy(secretKey.getEncoded(), 32, iv, 0, 16);
            SecretKeySpec secret = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int mode = forEncryption ? 1 : 2;
            cipher.init(mode, (Key)secret, ivSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new RuntimeException("Unable to create AES cipher", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unable to create AES cipher: check for Java8_151+ or install Unlimited Strength Java Cryptography Extension jars", e);
        }
    }
}

