/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import java.util.ArrayList;
import java.util.List;

public final class BigIntArray {
    private static int ITEM_SIZE = 16384;
    private final int count;
    private final List<int[]> items;

    public BigIntArray(int capacity) {
        this(capacity, false);
    }

    public BigIntArray(int capacity, boolean initializeWithAscendingRange) {
        int i;
        this.count = capacity;
        int numItems = this.count / ITEM_SIZE;
        if (this.count % ITEM_SIZE > 0) {
            ++numItems;
        }
        this.items = new ArrayList<int[]>();
        for (i = 0; i < numItems; ++i) {
            int neededSize = i == numItems - 1 ? this.count % ITEM_SIZE : ITEM_SIZE;
            this.items.add(new int[neededSize]);
        }
        if (initializeWithAscendingRange) {
            for (i = 0; i < this.count; ++i) {
                this.set(i, i);
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public void set(int index, int value) {
        int item = this.convertIndexToItem(index);
        int indexInItem = this.convertIndexToIndexInItem(index);
        this.items.get((int)item)[indexInItem] = value;
    }

    public int get(int index) {
        int item = this.convertIndexToItem(index);
        int indexInItem = this.convertIndexToIndexInItem(index);
        return this.items.get(item)[indexInItem];
    }

    private int convertIndexToItem(int index) {
        return index / ITEM_SIZE;
    }

    private int convertIndexToIndexInItem(int index) {
        return index % ITEM_SIZE;
    }

    public int hashCode() {
        return new Integer(this.count).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigIntArray)) {
            return false;
        }
        BigIntArray other = (BigIntArray)o;
        if (this.count != other.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }
}

