/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumns;

import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.trailer.Column;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class InternalColumn {
    private static final String DISPLAY_MASK = "displayMask";
    private static final String INPUT_MASK = "inputMask";
    private final ColumnTypes type;
    private final String name;
    private final String javaCompatibleInputMask;
    private final String javaCompatibleDisplayMask;
    private final Map<String, String> properties;
    private final Map<String, Integer> extrasLookup;
    private final DateTimeFormatter inputMaskFormatter;

    public InternalColumn(ColumnTypes type, String name, String inputMask, String displayMask) {
        this.type = type;
        this.name = name;
        this.properties = new HashMap<String, String>();
        this.extrasLookup = new HashMap<String, Integer>();
        this.javaCompatibleInputMask = InternalColumn.fixInputMask(this.type, inputMask);
        this.inputMaskFormatter = InternalColumn.createDateTimeFormatter(this.type, this.javaCompatibleInputMask);
        this.javaCompatibleDisplayMask = InternalColumn.fixDisplayMask(this.type, displayMask);
        this.properties.put(INPUT_MASK, inputMask);
        this.properties.put(DISPLAY_MASK, displayMask);
    }

    InternalColumn(Column protoColumn) {
        this.type = ColumnTypes.from(protoColumn.getType());
        this.name = protoColumn.getName();
        this.properties = new HashMap<String, String>();
        this.extrasLookup = new HashMap<String, Integer>();
        this.javaCompatibleInputMask = InternalColumn.fixInputMask(this.type, protoColumn.getPropertiesOrDefault(INPUT_MASK, ""));
        this.inputMaskFormatter = InternalColumn.createDateTimeFormatter(this.type, this.javaCompatibleInputMask);
        this.javaCompatibleDisplayMask = InternalColumn.fixDisplayMask(this.type, protoColumn.getPropertiesOrDefault(DISPLAY_MASK, ""));
        this.properties.put(INPUT_MASK, protoColumn.getPropertiesOrDefault(INPUT_MASK, ""));
        this.properties.put(DISPLAY_MASK, protoColumn.getPropertiesOrDefault(DISPLAY_MASK, ""));
    }

    public ColumnTypes getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getJavaCompatibleInputMask() {
        return this.javaCompatibleInputMask;
    }

    public DateTimeFormatter getInputMaskFormatter() {
        return this.inputMaskFormatter;
    }

    public String getJavaCompatibleDisplayMask() {
        return this.javaCompatibleDisplayMask;
    }

    private String getInputMask() {
        return this.properties.getOrDefault(INPUT_MASK, "");
    }

    private String getDisplayMask() {
        return this.properties.getOrDefault(DISPLAY_MASK, "");
    }

    private static DateTimeFormatter createDateTimeFormatter(ColumnTypes type, String inputMask) {
        switch (type) {
            case Time: {
                if (StringUtils.isEmpty((CharSequence)inputMask)) {
                    return null;
                }
                int milliPlaces = 0;
                if (inputMask.contains("f") || inputMask.contains("F")) {
                    Map<String, Long> map = inputMask.chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.groupingBy(Object::toString, Collectors.counting()));
                    if (map.containsKey("f")) {
                        milliPlaces += map.get("f").intValue();
                    }
                    if (map.containsKey("F")) {
                        milliPlaces += map.get("F").intValue();
                    }
                    inputMask = StringUtils.replace((String)inputMask, (String)"f", (String)"");
                    inputMask = StringUtils.replace((String)inputMask, (String)"F", (String)"");
                }
                if (!inputMask.contains("H") && !inputMask.contains("K")) {
                    inputMask = "HH:" + inputMask;
                }
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern(inputMask);
                if (milliPlaces > 0) {
                    builder.appendValue(ChronoField.MILLI_OF_SECOND, milliPlaces);
                }
                return builder.toFormatter();
            }
        }
        return null;
    }

    private static String fixInputMask(ColumnTypes type, String inputMask) {
        if (StringUtils.isEmpty((CharSequence)inputMask)) {
            return "";
        }
        switch (type) {
            case Time: {
                inputMask = inputMask.replace("f", "SSS");
                if (!inputMask.contains("K") && !inputMask.contains("H")) {
                    inputMask = "HH:" + inputMask;
                }
                return inputMask;
            }
        }
        return inputMask;
    }

    private static String fixDisplayMask(ColumnTypes type, String displayMask) {
        if (StringUtils.isEmpty((CharSequence)displayMask)) {
            return "";
        }
        switch (type) {
            case Double: {
                int index = displayMask.indexOf(";");
                if (index >= 0) {
                    displayMask = displayMask.substring(0, index);
                }
                return displayMask;
            }
            case Time: {
                String[] cSharpFormats = new String[]{".fff", ".ff", ".f"};
                String[] javaFormats = new String[]{".SSS", ".SS", ".S"};
                for (int i = 0; i < cSharpFormats.length; ++i) {
                    int index = displayMask.indexOf(cSharpFormats[i]);
                    if (index < 0) continue;
                    displayMask = displayMask.replace(cSharpFormats[i], javaFormats[i]);
                    return displayMask;
                }
                return displayMask;
            }
        }
        return displayMask;
    }
}

