/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.internalColumnSegments.datetimes.DateNormalizer;
import com.exponam.core.internalColumns.InternalColumn;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class InternalDateTimeColumnSegmentUtilities {
    public static final Timestamp EmptyDateTime = DateNormalizer.EMPTY_DATE_TIME;
    public static final Long Empty = EmptyDateTime.getTime();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static Function<Timestamp, Long> toAtRest = InternalDateTimeColumnSegmentUtilities::sinceDateBasis;
    static Function<Long, Timestamp> toInMemory = InternalDateTimeColumnSegmentUtilities::daysSinceDateBasis;
    public static BiFunction<Long, InternalColumn, String> atRestToString = (value, column) -> {
        if (value.equals(Empty)) {
            return "";
        }
        Timestamp datetime = InternalDateTimeColumnSegmentUtilities.daysSinceDateBasis(value);
        if (StringUtils.isEmpty((CharSequence)column.getJavaCompatibleDisplayMask())) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.format(datetime);
            }
        }
        SimpleDateFormat displaySdf = new SimpleDateFormat(column.getJavaCompatibleDisplayMask());
        return displaySdf.format(datetime);
    };

    private static Long sinceDateBasis(Timestamp date) {
        return DateNormalizer.cSharpTicksFromJavaTimestamp(date);
    }

    private static Timestamp daysSinceDateBasis(Long cSharpTicks) {
        return DateNormalizer.javaTimestampFromCSharpTicks(cSharpTicks);
    }
}

