/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.ImmutablePair;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithOneValue;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentWrapper;
import com.exponam.core.internalColumns.InternalColumn;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class InternalColumnSegmentBase {
    private WeakReference<InternalColumn> owningColumn;

    public final void attachColumn(InternalColumn column) {
        this.owningColumn = new WeakReference<InternalColumn>(column);
    }

    protected final InternalColumn getColumn() {
        return (InternalColumn)this.owningColumn.get();
    }

    public abstract int count();

    public abstract <T> T atRestValueForIndex(int var1);

    public abstract <T> T inMemoryValueForIndex(int var1);

    public abstract String stringValueForIndex(int var1);

    public abstract IBitArray applyFilter(InternalColumnSegmentFilterBase var1);

    public <T> void doForSpecificRows(Supplier<ImmutableTriple<Integer, Boolean, Consumer<T>>> nextRowFetcher) {
        Boolean stopAfterThisRow;
        do {
            ImmutableTriple<Integer, Boolean, Consumer<T>> triple = nextRowFetcher.get();
            Integer rowNumber = (Integer)triple.left;
            stopAfterThisRow = (Boolean)triple.middle;
            Consumer callbackWithAtRestValue = (Consumer)triple.right;
            callbackWithAtRestValue.accept(this.atRestValueForIndex(rowNumber));
        } while (!stopAfterThisRow.booleanValue());
    }

    public abstract ColumnSegmentBase toProto();

    public static class ColumnSegmentMaker<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> {
        private final OneValueSegmentMakerFunction<TInMemory, TAtRest> oneValueMakerFunction;
        private final RowOrderSegmentMakerFunction<TInMemory, TAtRest> rowOrderValuesMakerFunction;
        private final SortedValuesSegmentMakerFunction<TInMemory, TAtRest> sortedValuesMakerFunction;
        private final AtRestCostInBytesFunction<TInMemory> atRestCostInBytes;

        public ColumnSegmentMaker(OneValueSegmentMakerFunction<TInMemory, TAtRest> oneValueMakerFunction, RowOrderSegmentMakerFunction<TInMemory, TAtRest> rowOrderValuesMakerFunction, SortedValuesSegmentMakerFunction<TInMemory, TAtRest> sortedValuesMakerFunction, AtRestCostInBytesFunction<TInMemory> atRestCostInBytes) {
            this.oneValueMakerFunction = oneValueMakerFunction;
            this.rowOrderValuesMakerFunction = rowOrderValuesMakerFunction;
            this.sortedValuesMakerFunction = sortedValuesMakerFunction;
            this.atRestCostInBytes = atRestCostInBytes;
        }

        public InternalColumnSegmentBase getAppropriateColumnSegment(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
            if (numRowsInSegment <= 0) {
                throw new IllegalArgumentException("numRowsInSegment must be > 0");
            }
            if (valuesAndRows.keySet().size() <= 0) {
                throw new IllegalArgumentException("keySet must be > 0");
            }
            if (valuesAndRows.keySet().size() == 1) {
                return this.oneValueMakerFunction.apply(numRowsInSegment, (Comparable)valuesAndRows.keySet().iterator().next());
            }
            if (columnSegmentBuilderHint.hint() == 0) {
                return this.rowOrderValuesMakerFunction.apply(numRowsInSegment, valuesAndRows);
            }
            if (columnSegmentBuilderHint.hint() == 1 && CostEstimator.smallestApproximatedAtRestFootprint(numRowsInSegment, valuesAndRows, this.atRestCostInBytes) == CostEstimator.Choices.RowOrder) {
                return this.rowOrderValuesMakerFunction.apply(numRowsInSegment, valuesAndRows);
            }
            if (columnSegmentBuilderHint.hint() == 2) {
                try {
                    ImmutablePair<CostEstimator.Choices, InternalColumnSegmentBase> costEstimate = CostEstimator.smallestActualAtRestFootprint(numRowsInSegment, valuesAndRows, this.rowOrderValuesMakerFunction, this.sortedValuesMakerFunction);
                    return costEstimate.getItem2();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (IndexedValuesBitFieldPacker.canUsePackedEntries(valuesAndRows.keySet().size())) {
                return this.sortedValuesMakerFunction.apply(numRowsInSegment, valuesAndRows, columnSegmentBuilderHint);
            }
            throw new IllegalArgumentException("More than 2^16 values?  Impossible.");
        }
    }

    @FunctionalInterface
    public static interface AtRestCostInBytesFunction<TInMemory> {
        public int apply(TInMemory var1);
    }

    @FunctionalInterface
    public static interface SortedValuesSegmentMakerFunction<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> {
        public ColumnSegmentWithSortedValues<TInMemory, TAtRest> apply(Integer var1, Map<TInMemory, List<Integer>> var2, ColumnSegmentBuilderHint var3);
    }

    @FunctionalInterface
    public static interface RowOrderSegmentMakerFunction<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> {
        public ColumnSegmentWithRowOrderValues<TInMemory, TAtRest> apply(Integer var1, Map<TInMemory, List<Integer>> var2);
    }

    @FunctionalInterface
    public static interface OneValueSegmentMakerFunction<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> {
        public ColumnSegmentWithOneValue<TInMemory, TAtRest> apply(Integer var1, TInMemory var2);
    }

    static class CostEstimator {
        private static final double SCALING_FACTOR = 0.1;

        CostEstimator() {
        }

        static <TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> ImmutablePair<Choices, InternalColumnSegmentBase> smallestActualAtRestFootprint(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, RowOrderSegmentMakerFunction<TInMemory, TAtRest> rowOrderValuesMaker, SortedValuesSegmentMakerFunction<TInMemory, TAtRest> sortedValuesMaker) throws IOException {
            byte[] sortedValueBytes;
            ColumnSegmentWithRowOrderValues<TInMemory, TAtRest> columnSegmentWithRowOrderValues = rowOrderValuesMaker.apply(numRowsInSegment, valuesAndRows);
            ColumnSegmentWithSortedValues<TInMemory, TAtRest> columnSegmentWithSortedValues = sortedValuesMaker.apply(numRowsInSegment, valuesAndRows, ColumnSegmentBuilderHint.smallestPossible());
            InternalColumnSegmentWrapper rowOrderColumnSegmentWrapper = new InternalColumnSegmentWrapper(columnSegmentWithRowOrderValues);
            InternalColumnSegmentWrapper sortedValueColumnSegmentWrapper = new InternalColumnSegmentWrapper(columnSegmentWithSortedValues);
            byte[] rowOrderBytes = rowOrderColumnSegmentWrapper.serializeAndCompressAndMaybeEncrypt(() -> null);
            InternalColumnSegmentBase smallest = rowOrderBytes.length < (sortedValueBytes = sortedValueColumnSegmentWrapper.serializeAndCompressAndMaybeEncrypt(() -> null)).length ? columnSegmentWithRowOrderValues : columnSegmentWithSortedValues;
            Choices choice = rowOrderBytes.length < sortedValueBytes.length ? Choices.RowOrder : Choices.SortedValues;
            return ImmutablePair.of(choice, smallest);
        }

        static <TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>> Choices smallestApproximatedAtRestFootprint(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, AtRestCostInBytesFunction<TInMemory> atRestCostInBytesFunction) {
            int sortedValuesCost = valuesAndRows.keySet().stream().map(atRestCostInBytesFunction::apply).reduce(0, Integer::sum);
            int bitsPerEntry = IndexedValuesBitFieldPacker.calculateBitsPerEntry(valuesAndRows.keySet().size() - 1);
            int rowOrderCost = valuesAndRows.entrySet().stream().map(entry -> atRestCostInBytesFunction.apply((Comparable)entry.getKey()) * ((List)entry.getValue()).size()).mapToInt(Integer::intValue).sum();
            return (double)rowOrderCost * 0.1 < (double)(sortedValuesCost += numRowsInSegment * bitsPerEntry / 8) ? Choices.RowOrder : Choices.SortedValues;
        }

        static enum Choices {
            SortedValues,
            RowOrder;

        }
    }
}

