/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilterResult;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Operations {
    public static IBitArray and(IBitArray[] arrays) {
        if (arrays.length == 0) {
            throw new IllegalArgumentException("Expected arrays to not be empty");
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        List<IBitArray> list = Arrays.asList(arrays);
        if (list.stream().anyMatch(elem -> elem.count() != arrays[0].count())) {
            throw new IllegalArgumentException("Arrays must all be the same length");
        }
        if (list.stream().anyMatch(elem -> elem instanceof AllFalseBitArray)) {
            return new AllFalseBitArray(arrays[0].count());
        }
        if ((list = list.stream().filter(elem -> !(elem instanceof AllTrueBitArray)).collect(Collectors.toList())).size() == 0) {
            return arrays[0];
        }
        IBitArray answer = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            answer = Operations.and(answer, list.get(i));
        }
        return answer;
    }

    public static IBitArray and(IBitArray a, IBitArray b) {
        if (a.count() != b.count()) {
            throw new IllegalArgumentException("Counts cannot be different");
        }
        if (a instanceof AllFalseBitArray) {
            return a;
        }
        if (b instanceof AllFalseBitArray) {
            return b;
        }
        if (a instanceof AllTrueBitArray) {
            return b;
        }
        if (b instanceof AllTrueBitArray) {
            return a;
        }
        return ((BitArray)a).And((BitArray)b);
    }

    public static IBitArray or(IBitArray a, IBitArray b) {
        if (a.count() != b.count()) {
            throw new IllegalArgumentException("Counts cannot be different");
        }
        if (a instanceof AllTrueBitArray) {
            return a;
        }
        if (b instanceof AllTrueBitArray) {
            return b;
        }
        if (a instanceof AllFalseBitArray) {
            return b;
        }
        if (b instanceof AllFalseBitArray) {
            return a;
        }
        return ((BitArray)a).Or((BitArray)b);
    }
}

