/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilterResult;

import com.exponam.core.CommonProperties;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.Operations;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ConsolidatedColumnSegmentFilterResults {
    private final IBitArray[] segmentLevelResults;
    private final int totalRowsForAllSegments;

    public ConsolidatedColumnSegmentFilterResults(int totalRowsForAllSegments, List<IBitArray> segmentLevelResults) {
        this.totalRowsForAllSegments = totalRowsForAllSegments;
        this.segmentLevelResults = segmentLevelResults.toArray(new IBitArray[0]);
    }

    private ConsolidatedColumnSegmentFilterResults(int totalRowsForAllSegments, IBitArray[] segmentLevelResults) {
        this.totalRowsForAllSegments = totalRowsForAllSegments;
        this.segmentLevelResults = segmentLevelResults;
    }

    public int getTotalRowsForAllSegments() {
        return this.totalRowsForAllSegments;
    }

    IBitArray getSegmentLevelResult(int segment) {
        return this.segmentLevelResults[segment];
    }

    public int numRowsPassingFilter() {
        int result = 0;
        for (int i = 0; i < this.segmentLevelResults.length; ++i) {
            result += this.segmentLevelResults[i].numPasses();
        }
        return result;
    }

    public void forEachPassingRow(int totalPassedExpected, Consumer<Integer> doToRowFunc) {
        IBitArray bitArray;
        int numPassesEncountered = 0;
        int segmentLevelResultIndex = 0;
        for (int rowOffsetToCurrentSegment = 0; rowOffsetToCurrentSegment < this.totalRowsForAllSegments; rowOffsetToCurrentSegment += bitArray.count()) {
            bitArray = this.segmentLevelResults[segmentLevelResultIndex++];
            int rowOffsetToCurrentSegmentForClosure = rowOffsetToCurrentSegment;
            numPassesEncountered += bitArray.forEachPassingRow(rowInSegmentThatPasses -> doToRowFunc.accept(rowOffsetToCurrentSegmentForClosure + rowInSegmentThatPasses));
        }
        if (numPassesEncountered != totalPassedExpected) {
            throw new IllegalArgumentException("passes encountered differs from expected");
        }
    }

    public boolean getRowLevelResult(int row) {
        int segment = row / 32768;
        return this.segmentLevelResults[segment].get(row % 32768);
    }

    public static ConsolidatedColumnSegmentFilterResults intersect(List<ConsolidatedColumnSegmentFilterResults> individualColumnResults) {
        if (individualColumnResults.size() == 1) {
            return individualColumnResults.get(0);
        }
        int totalRowsForAllSegments = individualColumnResults.get(0).getTotalRowsForAllSegments();
        int numColumnSegments = CommonProperties.numSegmentsForRows(totalRowsForAllSegments);
        List segmentList = IntStream.range(0, numColumnSegments).boxed().collect(Collectors.toList());
        IBitArray[] intersectedSegmentLevelResults = new IBitArray[segmentList.size()];
        segmentList.parallelStream().forEach(segment -> {
            IBitArray[] segmentLevelResults = ConsolidatedColumnSegmentFilterResults.getResultsForSegment(individualColumnResults, segment);
            intersectedSegmentLevelResults[segment.intValue()] = Operations.and(segmentLevelResults);
        });
        return new ConsolidatedColumnSegmentFilterResults(totalRowsForAllSegments, intersectedSegmentLevelResults);
    }

    private static IBitArray[] getResultsForSegment(List<ConsolidatedColumnSegmentFilterResults> individualColumnResults, int segment) {
        IBitArray[] resultsForSegment = new IBitArray[individualColumnResults.size()];
        for (int i = 0; i < individualColumnResults.size(); ++i) {
            resultsForSegment[i] = individualColumnResults.get(i).getSegmentLevelResult(segment);
        }
        return resultsForSegment;
    }
}

