/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader;

import com.exponam.core.CommonProperties;
import com.exponam.core.FileCheckSum;
import com.exponam.core.InternalMetadatum;
import com.exponam.core.InternalTrailerReadable;
import com.exponam.core.InternalTrailerUncompressedReadable;
import com.exponam.core.InternalWorksheet;
import com.exponam.core.OffsetAndLength;
import com.exponam.core.crypto.IDecryptor;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import com.exponam.core.internalColumnSegments.ReaderUtilities;
import com.exponam.core.reader.BigMemoryCache;
import com.exponam.core.reader.BigReaderColumnSegmentCacheKey;
import com.exponam.core.reader.MetadataReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class BigReader
implements Closeable {
    private static AtomicInteger _globalId = new AtomicInteger(0);
    private final int _id = _globalId.incrementAndGet();
    private FileInputStream reader;
    private boolean ownsReader = false;
    private final BigMemoryCache<BigReaderColumnSegmentCacheKey, InternalColumnSegmentBase> memoryCache;
    private final InternalTrailerUncompressedReadable trailerUncompressed;
    private final InternalTrailerReadable trailer;
    private final MetadataReader metadataReader;
    private Map<String, Integer> columnIndexesByUpperCaseColumnNames;
    private boolean decryptorHasBeenSet = false;
    private IDecryptor decryptor;

    public BigReader(String file) throws IOException, UnsupportedFileVersionException {
        this(new FileInputStream(file));
        this.ownsReader = true;
    }

    public BigReader(FileInputStream reader) throws IOException, UnsupportedFileVersionException {
        this.reader = reader;
        Pair<InternalTrailerUncompressedReadable, InternalTrailerReadable> trailers = BigReader.readTrailers(reader);
        this.trailerUncompressed = (InternalTrailerUncompressedReadable)trailers.getLeft();
        this.trailer = (InternalTrailerReadable)trailers.getRight();
        if (this.trailerUncompressed.version() > 2) {
            throw new UnsupportedFileVersionException();
        }
        this.memoryCache = new BigMemoryCache();
        this.columnIndexesByUpperCaseColumnNames = new HashMap<String, Integer>();
        this.metadataReader = new MetadataReader(this);
    }

    public void setDecryptor(IDecryptor decryptor) {
        this.decryptor = decryptor;
        this.decryptorHasBeenSet = true;
    }

    IDecryptor getDecryptor() {
        if (!this.decryptorHasBeenSet) {
            throw new IllegalStateException("Decryptor has not been set");
        }
        return this.decryptor;
    }

    public MetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    public InternalWorksheet getWorksheet(int worksheetIndex) {
        if (!this.decryptorHasBeenSet) {
            throw new IllegalStateException("Attempting to access Worksheet before decryptor has been established.");
        }
        try {
            return this.trailer.getPrivateTrailerReadable(this.decryptor).getWorksheet(worksheetIndex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    InternalTrailerReadable getTrailer() {
        return this.trailer;
    }

    public SignatureValidationResult validateSignature() throws IOException {
        Pair<MetadataReader.Security, InternalMetadatum> signatureType = this.getMetadataReader().getSingleMetadatum("ExponamSigType", false, false);
        if (signatureType == null) {
            return SignatureValidationResult.NoSignature;
        }
        switch (((InternalMetadatum)signatureType.getRight()).getValueAsString()) {
            case "SHA256_ENC": {
                byte[] originalCheckSum;
                if (this.trailerUncompressed.encryptedSignature().length != 48) {
                    return SignatureValidationResult.BadSignature;
                }
                byte[] currentCheckSum = FileCheckSum.generateCheckSum(this.reader, FileCheckSum.getHashableSections(this.reader));
                return Arrays.equals(currentCheckSum, originalCheckSum = this.getDecryptor().decrypt(this.trailerUncompressed.encryptedSignature())) ? SignatureValidationResult.GoodSignature : SignatureValidationResult.BadSignature;
            }
        }
        return SignatureValidationResult.UnknownSignature;
    }

    private int getNumColumnSegments(int worksheet) {
        return CommonProperties.numSegmentsForRows(this.getWorksheet(worksheet).getNumRows());
    }

    public <T, ConsolidatedT> void doToColumn(int worksheet, int column, Function<InternalColumnSegmentBase, T> doToColumnSegment, Function<List<T>, ConsolidatedT> consolidate, Consumer<ConsolidatedT> notify) {
        List segmentList = IntStream.range(0, this.getNumColumnSegments(worksheet)).boxed().collect(Collectors.toList());
        ArrayList<String> results = new ArrayList<String>(segmentList.size());
        for (int i = 0; i < segmentList.size(); ++i) {
            results.add("undefined");
        }
        segmentList.parallelStream().forEach(segment -> {
            InternalColumnSegmentBase columnSegment = this.getColumnSegment(worksheet, (int)segment, column);
            Object resultForColumnSegment = doToColumnSegment.apply(columnSegment);
            List list = results;
            synchronized (list) {
                results.set((int)segment, (String)resultForColumnSegment);
            }
        });
        ConsolidatedT finalResult = consolidate.apply(results);
        notify.accept(finalResult);
    }

    public Map<String, Integer> getColumnIndexesByUpperCaseColumnNames(int worksheet) {
        if (this.columnIndexesByUpperCaseColumnNames.isEmpty()) {
            List<String> columnNames = this.getWorksheet(worksheet).getColumns().columnNames();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = columnNames.get(i);
                this.columnIndexesByUpperCaseColumnNames.put(columnName.toUpperCase(), i);
            }
        }
        return this.columnIndexesByUpperCaseColumnNames;
    }

    public String getValueAsString(int worksheet, int row, int column) {
        int segment = row / 32768;
        InternalColumnSegmentBase columnSegment = this.getColumnSegment(worksheet, segment, column);
        int rowInSegment = row % 32768;
        return columnSegment.stringValueForIndex(rowInSegment);
    }

    public Object getValue(int worksheet, int row, int column) {
        int segment = row / 32768;
        InternalColumnSegmentBase columnSegment = this.getColumnSegment(worksheet, segment, column);
        int rowInSegment = row % 32768;
        return columnSegment.inMemoryValueForIndex(rowInSegment);
    }

    private InternalColumnSegmentBase getColumnSegment(int worksheet, int segment, int column) {
        BigReaderColumnSegmentCacheKey key = new BigReaderColumnSegmentCacheKey(worksheet, segment, column);
        return this.memoryCache.guaranteedGet(key, () -> {
            try {
                return this.readColumnSegment(this.reader, this.decryptor, worksheet, segment, column);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalColumnSegmentBase readColumnSegment(FileInputStream binaryReader, IDecryptor decryptor, int worksheet, int segment, int column) throws IOException {
        byte[] rawSegmentBytes;
        OffsetAndLength offsetAndLength = this.getTrailer().getXRefReadable().getEntry(worksheet, segment, column);
        BigReader bigReader = this;
        synchronized (bigReader) {
            rawSegmentBytes = new byte[((Integer)offsetAndLength.getItem2()).intValue()];
            binaryReader.getChannel().position((Long)offsetAndLength.getItem1());
            int bytesRead = binaryReader.read(rawSegmentBytes);
            if (bytesRead != rawSegmentBytes.length) {
                throw new RuntimeException(String.format("Failed to read segment for worksheet=%d, segment=%d, column=%d.  Expected %d bytes, received %d", worksheet, segment, column, rawSegmentBytes.length, bytesRead));
            }
        }
        byte[] decryptedSegmentBytes = decryptor.decrypt(rawSegmentBytes);
        InternalColumnSegmentBase columnSegmentBase = ReaderUtilities.fromProto(decryptedSegmentBytes, this.getWorksheet(worksheet).getColumns().get(column).getType());
        columnSegmentBase.attachColumn(this.getWorksheet(worksheet).getColumns().get(column));
        return columnSegmentBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<InternalTrailerUncompressedReadable, InternalTrailerReadable> readTrailers(FileInputStream reader) throws IOException {
        FileInputStream fileInputStream = reader;
        synchronized (fileInputStream) {
            long fileLength = reader.getChannel().size();
            long readFrom = fileLength - 4L;
            byte[] trailerUncompressedLengthBytes = new byte[4];
            reader.getChannel().position(readFrom);
            int trailerUncompressedLengthBytesRead = reader.read(trailerUncompressedLengthBytes, 0, 4);
            if (trailerUncompressedLengthBytesRead != 4) {
                throw new RuntimeException("Failed to read trailer uncompressed length");
            }
            int trailerUncompressedLength = BigReader.toInt(trailerUncompressedLengthBytes);
            long trailerUncompressedStartPosition = readFrom - (long)trailerUncompressedLength;
            byte[] trailerUncompressedBytes = new byte[trailerUncompressedLength];
            reader.getChannel().position(trailerUncompressedStartPosition);
            int trailerUncompressedBytesRead = reader.read(trailerUncompressedBytes, 0, trailerUncompressedLength);
            if (trailerUncompressedBytesRead != trailerUncompressedLength) {
                throw new RuntimeException("Failed to read trailer uncompressed");
            }
            InternalTrailerUncompressedReadable internalTrailerUncompressedReadable = InternalTrailerUncompressedReadable.deserialize(trailerUncompressedBytes);
            readFrom = trailerUncompressedStartPosition - 4L;
            byte[] trailerLengthBytes = new byte[4];
            reader.getChannel().position(readFrom);
            int trailerLengthBytesRead = reader.read(trailerLengthBytes, 0, 4);
            if (trailerLengthBytesRead != 4) {
                throw new RuntimeException("Failed to read trailer length");
            }
            int trailerLength = BigReader.toInt(trailerLengthBytes);
            long trailerStartPosition = readFrom - (long)trailerLength;
            byte[] trailerBytes = new byte[trailerLength];
            reader.getChannel().position(trailerStartPosition);
            int trailerBytesRead = reader.read(trailerBytes, 0, trailerLength);
            if (trailerBytesRead != trailerLength) {
                throw new RuntimeException("Failed to read trailer");
            }
            InternalTrailerReadable internalTrailerReadable = InternalTrailerReadable.decompressAndDeserialize(trailerBytes);
            return Pair.of((Object)internalTrailerUncompressedReadable, (Object)internalTrailerReadable);
        }
    }

    private static int toInt(byte[] rawBytes) {
        int c1 = (0xFF & rawBytes[3]) << 24;
        int c2 = (0xFF & rawBytes[2]) << 16;
        int c3 = (0xFF & rawBytes[1]) << 8;
        int c4 = 0xFF & rawBytes[0];
        return c1 + c2 + c3 + c4;
    }

    @Override
    public void close() throws IOException {
        if (this.ownsReader && this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public static enum SignatureValidationResult {
        NoSignature,
        GoodSignature,
        BadSignature,
        UnknownSignature;

    }

    public static class UnsupportedFileVersionException
    extends Exception {
    }
}

